//---------------------------------------------------------------------------
//#include </cbuilder/include/vcl/vcl.h>
//#include </cbuilder/include/stdlib.h>
//#include </cbuilder/include/stdio.h>
//#pragma hdrstop
//#include </cbuilder/include/winbase.h>

#include "getopt.h"
#include "defs.h"
#include "test.h"
#include "userio.h"
#include "debug.h"
#include "data.h"
#include "utils.h"
#include "vario.h"
#include "glvars.h"
#include "xvalid.h"
#include "read.h"
#include "lex.h"
#include "sem_main.h"
#include "sem.h"
#include "reml.h"
#include "fit.h"
#include "plot.h"
#include "stat.h"
#include "random.h"
#include "ui.h"
#include "predict.h"
#include "mapio.h"
#include "polygon.h"
#include "map2gif.h"
#include "sample.h"
#include "version.h"
#include "parsecmd.h"
//--------------------------------------------------------------------------
//#include "parse.cpp"
#include "data.cpp"
#include "direct.cpp"
#include "fit.cpp"
#include "getest.cpp"
#include "getopt.cpp"
#include "gls.cpp"
#include "glvars.cpp"
#include "gstat_main.cpp"
#include "lm.cpp"
#include "map2gif.cpp"
#include "mapio.cpp"
#include "msim.cpp"
#include "block.cpp"
#include "xvalid.cpp"
#include "polygon.cpp"
#include "pqueue.cpp"
#include "predict.cpp"
#include "random.cpp"
#include "read.cpp"
#include "reml.cpp"
#include "report.cpp"
#include "sample.cpp"
#include "search.cpp"
#include "select.cpp"
#include "sem.cpp"
#include "sem_main.cpp"
#include "sim.cpp"
#include "stat.cpp"
#include "ui.cpp"
#include "userio.cpp"
#include "utils.cpp"
#include "vario.cpp"
#include "vario_fn.cpp"
#include "vario_io.cpp"
#include "writecmd.cpp"
#include "parsecmd.cpp"
#include "\gstat-2.1.0\meschach\chfactor.cpp"
#include "\gstat-2.1.0\meschach\submat.cpp"
#include "\gstat-2.1.0\meschach\hsehldr.cpp"
#include "\gstat-2.1.0\meschach\err.cpp"
#include "\gstat-2.1.0\meschach\copy.cpp"
#include "\gstat-2.1.0\meschach\lufactor.cpp"
#include "\gstat-2.1.0\meschach\ivecop.cpp"
#include "\gstat-2.1.0\meschach\init.cpp"
#include "\gstat-2.1.0\meschach\memory.cpp"
#include "\gstat-2.1.0\meschach\matop.cpp"
#include "\gstat-2.1.0\meschach\machine.cpp"
#include "\gstat-2.1.0\meschach\solve.cpp"
#include "\gstat-2.1.0\meschach\pxop.cpp"
#include "\gstat-2.1.0\meschach\qrfactor.cpp"
#include "\gstat-2.1.0\meschach\norm.cpp"
#include "\gstat-2.1.0\meschach\sprow.cpp"
#include "\gstat-2.1.0\meschach\sparseio.cpp"
#include "\gstat-2.1.0\meschach\spchfctr.cpp"
#include "\gstat-2.1.0\meschach\sparse.cpp"
#include "\gstat-2.1.0\meschach\version.cpp"
#include "\gstat-2.1.0\meschach\update.cpp"
#include "\gstat-2.1.0\meschach\vecop.cpp"
#include "\gstat-2.1.0\meschach\bdfactor.cpp"
#include "\gstat-2.1.0\meschach\memstat.cpp"
#include "\gstat-2.1.0\meschach\meminfo.cpp"
#include "\gstat-2.1.0\meschach\matrixio.cpp"
//#include "lex.cpp");


//--------------------------------------------------------------------------
static void parse_options(int argc, char *argv[]);
static void read_all_data(DATA **data, DATA *valdata, int n_vars);
static void do_variogram(int nvars, METHOD m);
/*static int exec_action(int argc, char **argv);*//*KS removed*/
void remove_tmp(void);

#ifdef CYGWIN_ERRNOBUG /* seems to be a bug with -mno-cygwin; cygwin b20 */
int __errno;
#endif

char /**argv0 = NULL,*/ *command_line = NULL;
static int check_only = 0;

extern char *optarg;
extern int optind, opterr, optopt;

#define HELP "options:\n\
-C    print copyright notice\n\
-W    print no warranty claim\n\
-i    start interactive mode\n\
-v    print version information\n\
-c    check command file syntax and exit\n\
-r n  use random number generator n: -1 list options\n\
-e a  execute action a\n\n\
the following options have an equivalent command -> syntax:\n\
-d n  debug (sum) level: -1 list options         -> set debug = n;\n\
-o f  write output results to file f             -> set output = 'f';\n\
-l f  write debug log to file f                  -> set logfile = 'f';\n\
-p f  write plot commands to file f              -> set plotfile = 'f';\n\
-S    secure mode (no system, popen or remove)   -> set secure = 1;\n\
-x    cross validation                           -> set xvalid = 1;\n\
option arguments: f file name, n number, a action\n"


/*KS added for Idrisi API*/
int handle;
char *directory;
char *idrdirectory;
bool CORRELOGRAM = 0;
float default_misval_idrisi = 0.0;
unsigned long perc1;
unsigned  perc2; /*KS added for percent_done because API does not like numbers passed directly*/
/*KS*/ char *gl_outname_tmp2;/*KS added*/
CEFile      co_file;
CEFile*      o_file2 = &co_file;
FILE        *o_file;
char *argv0;
int	opterr = 1; /*init_predictions*/
char gerr_text[ERR_TEXT_SIZE];

/*#ifndef LIBGSTAT
int main(int argc, char *argv[]) {
#else *//*KS removed*/
int main(int argc, char *argv[]) {
/*#endif*/

	DATA      **data = NULL, *valdata = NULL;
    int       i,j;/*KS added j*/
    char 	  *pathd = NULL; /*KS added*/
	//argv0 = argv[0];  Windows does not like -- KS

//try {/*KS added to trap unknown errors*/
/*
 * register command line arguments on command_line:
 */

    argv0 = (char *) erealloc(argv0,strlen(argv[0])); /*KS added*/

	command_line = store_argv(argc, argv);
/*
 * initialise some global variables:
 */
	init_userio(1);
	init_global_variables();
	/*parse_gstatrc();*//*KS removed*/
/*
 * INPUT: command line options;
 */
	parse_options(argc, argv); /* exits on -e options */

/*
 * start with program heading:
 */
/*	printlog("%s: %s version %s\n", GSTAT_HD, GSTAT_OS, VERSION);
	printlog("%s\n", GSTAT_CR);*/    /*KS*/

/*
 * INPUT: Find command file:
 */
/*	if (optind < argc - 1)
		pr_warning("ignoring last %d argument(s)", argc - 1 - optind);*//*KS removed*/
/*
 * INPUT: Parse command file:
 */
	if (optind == argc) { /* there's no command file name left */
		if (get_method() != UIF) { /* -i or -m command line option */
			/* no arguments */
/*			printlog("%s\n", USAGE);*/ /*KS*/
			ErrMsg(ER_NOCMD, "");
		}
	} else { /* we have a command file to be read */
     /* Get Idrisi data directory paths from command line - KS added**/
        if (optind <= argc - 1) { /* there are arguments left... */
		if (!almost_equals(argv[optind], "-")) {
            if (optind < argc - 1) {
                /*KS added following lines because C++ Builder interprets spaces in directories of paths as separate argc*/
                j = 0;
            	for (i = optind; i < argc; i++)
                    j += (strlen(argv[i]) + 1);
                command_file_name = (char *) emalloc(j);
                for (i = optind; i < argc; i++) {
                     strcat(command_file_name, argv[i]);
                     if (i != argc-1) strcat(command_file_name, " ");
                     }
            } else {
            command_file_name = (char *) emalloc(strlen(argv[optind]) + 1);
            strcpy(command_file_name,argv[optind]);
            }

        i = 0;

       	//while (command_file_name[i] != 0) i++; j = i--;
        j = strlen(command_file_name);
        while (command_file_name[j] != 92) j--; j++;

        directory = (char *) emalloc(j+1);
        strncpy(directory, (const char *) &(command_file_name[0]), j);
   /*end Get Idrisi ********************/

        }  /* end if !almost */
		/*command_file_name = argv[optind];*//*KS removed*/
		parse_cmd(command_file_name);  /*parse_file*//*KS changed to older version*/

    } /*if optind*/
    }

//	if (DEBUG_DUMP)
//		atexit(print_file_record);

//	atexit(remove_tmp);

   /*	if (!o_filename /*== NULL*///)  /* no `-o name', or `output: "name";' */
	/*	o_filename = gl_outname_tmp;*//*KS replaced*/
    if (!o_filename)// == NULL)
    { /* no `-o name', or `output: "name";' */
        o_filename = (char *) emalloc( 1 + strlen(gl_outname_tmp) ); /*KS*/strcpy(o_filename,gl_outname_tmp);
    }

	if (logfile_name /*!= NULL*/)
		set_gstat_log_file(efopen(logfile_name, "w"));

/*
 * get global variables locally:
 */
	data = 			get_data();
	valdata = 		get_dataval();
	set_seed(gl_seed);
/*
 * check variable settings and next
 * INPUT: read data values from file:
 */
	read_all_data(data, valdata, get_n_vars());
	if (get_method() == NSP) /* Still no answer to this: choose default */
		set_method(get_default_method());
	set_mode();
	check_global_variables();
	setup_meschach_error_handler();
	if (DEBUG_DUMP)
		dump_all();
	if (get_method() != NSP)
		printlog("[%s]\n", method_string(get_method()));
	if (check_only)
		exit(0);

/*	if (get_method() == UIF) {
		start_ui();
		exit(0);
	}*/                             /*KS removed user interface*/

/*
 * start calculations && OUTPUT routines:
 */
	gstat_start();
    perc1 = 1; perc2 = 100;          /*KS*/
    percent_done(perc1,perc2,handle);/*KS*/
	switch (get_method()) {
		case NSP:
		case UIF:
			break;
		case COV:
		case SEM:
			do_variogram(get_n_vars(), get_method());
			break;
        case POLY:
            setup_poly_method();
            /*FALLTHROUGH*/
		default:
			if (gl_xvalid) /* validation/cross validation */
				cross_valid(data);
			else
				predict_all(data); /* or prediction: */
			break;
	} /* switch get_method() */

	if (get_method() != UIF)
		elapsed();
/*
 * file closing & data freeing time:
 */
	if (plotfile /*!= NULL*/)
		efclose(plotfile);
	remove_all(); /* free all data etc. */

    efree(gl_outname_tmp);
    efree(gl_outname_tmp2);
    efree(directory);
    efree(idrdirectory);
    efree(command_file_name);
    efree(o_filename); /*KS added*/
    efree(command_line);
    efree(argv0);/*KS added*/
    perc1 = 99; perc2 = 100;
    percent_done(perc1, perc2, handle); /*KS added handle*//*1/18/99*/
/*    } catch ( ... )
    {
    perc1 = 9999; perc2 = 100;
    percent_done(perc1, perc2, handle); /*KS added exception handle*//*1/18/99*/
/*    ShowMessage("Out of range value generated. Try adjusting input values.");
    }*/

	exit(0);
} /* end of main() */

static void parse_options(int argc, char *argv[]) {
	int c, i;

	/* who am i, some -e option? */
/*	if (argc > 1 && almost_equals(argv[1], "-e$xecute"))
		exit(exec_action(argc - 2, argv + 2));*/

	/* no, plain gstat. Do the command line option parsing: */
	opterr = 0;
	while ((c = getopt(argc, argv, "Ccd:t:ehil:mo:p:r:sSvWxV")) != EOF) {
		switch (c) {
			case 'd':
				if (read_int(optarg, &debug_level) || debug_level < 0) {
					debug_level = 1;
					message(DEBUG_OPTIONS);
					ErrMsg(ER_ARGOPT, "d");
				}
				break;
 /*KS*/     case 't':
                if (read_int(optarg, &handle)) ErrMsg(ER_RDINT, optarg);
                break;/*KS*//*1/4/99*/ //to be used with postmessaging
			case 'e':
				ErrMsg(ER_ARGOPT, "option -e only allowed as first option");
 			case 'i':
			case 'm':
				set_method(UIF);
				break;
			case 'l':
				set_gstat_log_file(efopen(logfile_name = optarg, "w"));
				break;
			case 'o': o_filename = optarg; break;
			case 'p': gl_gnufile = optarg; break;
			case 'r':
				if (read_int(optarg, &i)) 
					ErrMsg(ER_RDINT, optarg); 
				set_random_number_generator(i); 
				break;
			case 'S': gl_secure = 1; break;
			case 's': debug_level = 0; break;
			case 'c': check_only = 1; break;
			case 'x': gl_xvalid = 1; break;
/*			case 'C': printlog("%s\n", COPYRIGHT); break;
			case 'W': printlog("%s\n", NOWARRANTY); break;
			case 'V': case 'v':
				printlog("compiled on:          %s\n", __DATE__);
				printlog("with libraries:       ");
#ifdef HAVE_LIBCSF
				printlog("csf ");
#endif
#ifdef HAVE_LIBCURSES
				printlog("curses ");
#endif
#ifdef HAVE_LIBGD
				printlog("gd ");
#endif
#ifdef HAVE_LIBGSL
				printlog("gsl ");
#endif
#ifdef HAVE_LIBNETCDF
				printlog("netcdf ");
#endif
#ifdef HAVE_LIBNCURSES
				printlog("ncurses ");
#endif
#ifdef LIBGSTAT
				printlog("qt");
#endif
#ifdef HAVE_LIBREADLINE
				printlog("readline ");
#endif
				printlog("\n");
				printlog("last modified on:     %s\n", LASTMOD);
				printlog("gstat home page:      %s\n", GSTAT_HOME);
				printlog("questions, bugs etc.  mailto:%s\n\n", GSTAT_INFO);
				break; *//*KS removed*/
			case 'h':
				printlog("%s\n\n%s\n", USAGE, HELP);
				break;
			case '?':
			default:
				ErrClo(optopt);
		}
	}
	return;
}

static void read_all_data(DATA **data, DATA *valdata, int n_vars) {
	int i;
	DATA *area;

	area = get_data_area();
	for (i = 0; i < n_vars; i++)  {
		if (get_mode() == STRATIFY)
			printlog("stratum # %d:\n", i + strata_min);
		printlog("data(%s): ", name_identifier(i));
/*		if (data[i]->id < 0) {
			message("data(%s) was not specified\n", name_identifier(i));
			ErrMsg(ER_SYNTAX, "data specification error");
		} */
		read_data(data[i]);
		report_data(data[i]);
	} /* for i */

/*
 * what to do when area is specified, but no masks or data()?
 * default prediction to `area'. Create a valdata with one point at
 * centre of area (for select()); and centre area at (0,0,0)
 */
	if (area && get_n_masks() <= 0 && valdata->id == -1) {
		valdata->id = ID_OF_VALDATA;
		valdata->centre = area->centre = 1;
	}
/* 
 * read data() data:
 */
	if (valdata->id > -1 && !area /*== NULL*/) {
		setup_valdata_X(valdata);
		if (! valdata->centre)
			valdata = read_data(valdata);
	}
/*
 * read area, if existed
 */
	if (area /*!= NULL*/ && get_method() != POLY) {
		read_data(area);
		/* now, before centring area: */
		if (valdata->centre)
			valdata = get_area_centre(area, valdata);
		if (area->centre)
			centre_area(area);
		printlog("area:%s\n", area->centre ? " (centred around 0)" : "");
		report_data(area);
		if (DEBUG_DATA)
			print_data_list(area);
	}
/*
 * read edges, if existed
 */
    if (get_n_edges() > 0) {
        read_edges();
        report_edges();
/*         setup_visibility_graph(); */
        
        /*setup_planar_subdivisions();*/
    }
/*
 * setup and report data
 */

	if (valdata->id > -1) {
		printlog("data():%s ",
			valdata->centre ? " [at area centre]" : "");
		report_data(valdata);
	}
	for (i = 0; i < n_vars; i++) 
		setup_data_minmax(data[i]);
	if (valdata->id > -1)
		setup_data_minmax(valdata);
	for (i = 0; i < n_vars; i++)
		calc_polynomials(data[i]);
	if (valdata->id > -1)
		calc_polynomials(valdata);
	if (DEBUG_DATA) {
		for (i = 0; i < n_vars; i++)
			print_data_list(data[i]);
		if (valdata->id > -1)
			print_data_list(valdata);
	}
}

void remove_tmp(void) {
	if (file_exists(gl_outname_tmp))
		eremove(gl_outname_tmp);
	if (file_exists(gl_gnuname_tmp))
		eremove(gl_gnuname_tmp);
	if (logfile_name /*!= NULL*/)
		set_gstat_log_file(NULL); /* close file */
}

static void do_variogram(int nvars, METHOD m) {
	int i, j;
	VARIOGRAM *vp = NULL;
    char 	  *pathd = NULL; /*KS added*/

	if (nvars == 0)
		return;

	/*
	if (plotfile && !gl_jgraph && almost_equals(o_filename, gl_outname_tmp))
		ErrMsg(ER_VARNOTSET, "name of output file (set output)");
	*/
	for (i = 0; i < nvars; i++) {
		for (j = i; j >= 0; j--) {
			vp = get_vgm(LTI(i,j)); /* */
			vp->id1 = j;
			vp->id2 = i;
			if (m == COV)
				vp->ev->evt = (i != j) ? CROSSCOVARIOGRAM : COVARIOGRAM;
			else
				vp->ev->evt = (i != j) ? CROSSVARIOGRAM : SEMIVARIOGRAM;

            /*KS added*/
            o_filename = (char *) erealloc(o_filename,( 1 + strlen(gl_outname_tmp)));
            strcpy(o_filename,gl_outname_tmp);
            pathd = (char *) emalloc( 2+ (strlen(directory)+ strlen(gl_outname_tmp)) );
            strcpy(pathd,directory); strcat(pathd,o_filename);
            o_file2->efopen(pathd, "w");
            /*end KS added*/

			calc_variogram(vp, o_file2/*vp->fname ? vp->fname : o_filename*/);

            o_file2->efclose(); /*KS added*/

			if (vp->n_models > 0 && gl_fit) {
				vp->ev->fit = (enum FIT_TYPE ) gl_fit;
				if (fit_variogram(vp))
					pr_warning("error during variogram fit");
				else {
                    /*KS added*/
                    o_filename = (char *) erealloc(o_filename, 1 +strlen(gl_outname_tmp2));
           			strcpy(o_filename,gl_outname_tmp2);
                    pathd = (char *) erealloc(pathd,( 2 + strlen(directory)+strlen(gl_outname_tmp2)));
					strcpy(pathd,directory); strcat(pathd,o_filename);
                    o_file2->efopen(pathd, "w");
                    fprint_variogram(o_file2, vp);
                    o_file2->efclose();
                    /*end KS added*/
					/*logprint_variogram(vp, 1);*//*KS removed*/
                    }
			}
		}
	}

	/*if (plotfile) {
		if (nvars > 1)
			ErrMsg(ER_IMPOSVAL, "plot file only works for single variable");
		if (vp->ev->map)
			ErrMsg(ER_IMPOSVAL, "cannot make plot file for variogram map");
		if (gl_jgraph)
			fprint_jgraph_variogram(plotfile, vp);
		else
			fprint_gnuplot_variogram(plotfile, vp, "gnuplot.out", GNUPLOT, 0);
	} *//*KS removed*/
    efree(pathd);/*KS added*/
}

/*static int exec_action(int argc, char *argv[]) {
	int i;
	const struct {
		const char *name, *ab_name;
		int (*prog_fn)(int c, char *v[]);
		const char *desc;
	} exec_actions[] = {
    	{ "convert",       "con$vert",      map_convert, "convert map format" },
		{ "cover",         "cov$er",        map_cover,   "combine non-missing valued areas from maps" },
		{ "cut",           "cu$t",          map_cut,     "cut square area from map" },
		{ "mapdiff",       "mapdiff",       map_diff,    "check difference between two maps" },
		{ "map2gif",       "map2gif",       map2gif,     "create gif from map" },
		{ "nominal",       "no$minal",      map_nominal, "convert n 0-1 maps into one 0...n-1 map" },
		{ "semivariance",  "semivariance",  vario,       "semivariance for variogram model" },
		{ "covariance",    "covariance",    vario,       "covariance for variogram model" },
		{ "semivariogram", "semivariogram", main_sem,    "sample variogram from data" },
		{ "covariogram",   "covariogram",   main_sem,    "sample covariogram from data" },
		{ "statistics",    "st$atistics",   calc_stats,  "sample summary statistics" },
		{ "sample",        "sa$mple",       sample_main, "map sampling" },
		{ "random",        "ra$ndom",       e_random,    "print random numbers" },
		{ NULL, NULL, NULL, NULL }
	};

	for (i = 0; exec_actions[i].name; i++)
		if (almost_equals(argv[0], exec_actions[i].ab_name))
			return exec_actions[i].prog_fn(argc, argv);
	if (argc)
		printlog("error: unknown action: %s\n", argv[0]);
	printlog("gstat -execute [action] [arguments]\n");
	printlog("valid actions are:\n");
	for (i = 0; exec_actions[i].name; i++)
		printlog("\t%-16s[%s]\n",
			exec_actions[i].name, exec_actions[i].desc);
	return 1;
}   */ /*KS removed*/
//---------------------------------------------------------------------------

