//---------------------------------------------------------------------------
#include <ctype.h>
#include <math.h>
#include <vcl.h> /*KS added*/
#pragma hdrstop

#include "parsecmd.h"
#include "data.h"
#include "glvars.h"
#include "utils.h"
#include "lex.h"
#include "gstat_main.h"
#include "userio.h"
#include "read.h"
#include "vario.h"
#include "debug.h"
#include "vario_fn.h"

//---------------------------------------------------------------------------
/*
 * parse_cmd(): LALR(1) parser for command[file|string];
 * commands are in form: keyword[(identifier[,identifier])]:value;
 * where keword is data([id1[,id2]]),var(id1[,id2]),est(id1),
 * block, mask, par, ...
 * value strings are parsed with special functions: parse_data();
 * parse_mask() etc.
 */
static void reset_lex2(void);
void set_lex_source2(/*const*/ char *source, const char *fname);
char *lex_error2(void);
int yylex2(void);
static int parse_id(int *id1, int *id2);
static int parse_data(int id);
static int parse_variogram(int id1, int id2);
static int parse_marginals(void);
static int parse_method(void);
static int parse_block(void);
static int parse_est(int id);
static int parse_var(int id1, int id2);
static int parse_set(int what);
static int parse_mask(void);
static int parse_bounds(int when);
static int parse_data_X(DATA *d);
static char *unquote_dup(const char *txt);

static void push_model(VARIOGRAM *v, VGM_MODEL part, int id);
static VGM_MODEL_TYPE which_model(const char *m);
static ANIS_TM* get_tm(double anis[5]);
int resid = 1;

#define CHECK {if (((currentToken = yylex2()) != LX_COLON) && currentToken != LX_EQ) {\
        argv0=lex_error2();\
		ErrMsg(ER_SYNTAX,argv0);}}

#ifndef PI
#   define PI 3.14159265359
#endif
#ifndef DEG2RAD
#	define DEG2RAD (PI/180.0)
#endif

static int loc_gl_n = -1;
static char *boundary_file = NULL;
static int yy_Lexpos = 0, yy_Posafternl = 1, My_yy_lineno = 1,
	new_source = 0;
static char *yy_Source = NULL, *lastnl = NULL;
static const char *yy_File_name = NULL;
//unsigned char yytext[256]; /*KS added*/
char yytext2[256];  //why unsigned char?
bool minus = 0;

extern int handle;
extern char *idrdirectory;
extern bool CORRELOGRAM;
extern float default_misval_idrisi;
extern char *argv0;
//use this for all the errors messages
extern char gerr_text[ERR_TEXT_SIZE];

int parse_cmd(const char *fname) {
/*
 * parse commands in file fname
 * a command is a sequence tokens, ending with a `;'
 */

	int currentToken, id1, id2, stdin_isatty = 1;
	char *cp = NULL;
#ifdef HAVE_UNISTD_H
	stdin_isatty = isatty(fileno(stdin));
#endif
    	id1=12;
/*KS	if (fname == NULL && stdin_isatty)
		cp = string_prompt("gstat> ");
	else /* read from file or pipe */
		cp = string_file(fname);
		set_lex_source2(cp, fname ? fname : "stdin");
        //err_text = (char *)emalloc(80); /*KS added*/
  /* Get Idrisi command and data directory paths from command line - KS added**/

    id2 = *yy_Source;
    if (id2 == 35) {  /* # */
    	yy_Source++; yy_Source++;
    	id2 = *yy_Source;
    	if (id2 == 58) {  /* : */
    		yy_Source--;
        	currentToken = 0;

        	while (*yy_Source != '\n') {
        		yytext2[currentToken] = *yy_Source;
            	currentToken++; yy_Source++;
            }
        	idrdirectory = (char *) emalloc(currentToken);
        	strncpy(idrdirectory, const_cast <char *> (&(yytext2[0])), currentToken);
        }
    	else yy_Source--;
    }

    yy_Source++;
    id2 = *yy_Source;
    if (id2 == 35) {  /* # */
        yy_Source++;
    	id2 = *yy_Source;
    	if (id2 == 67) {  /* C */
        	yy_Source++;
        	id2 = *yy_Source;
        	if (id2 == 79) {  /* O */
        		yy_Source++;
            	id2 = *yy_Source;
            	if (id2 == 82) {  /* R */
                	CORRELOGRAM = 1;
    				currentToken++;currentToken++;currentToken++;
        			while (*yy_Source != '\n') {
        				currentToken++; yy_Source++;
                	}
            	}
            	else {
            		yy_Source--;yy_Source--;yy_Source--;
            	}
        	}
        	else {
        		yy_Source--;yy_Source--;
        	}
    	}
    	else yy_Source--;
   } 
    /****end KS added *********************/

	/* start parsing */
	while ((currentToken = yylex2()) != 0 ) { /* while input.. */   //KS removed all yylex()
		id1 = id2 = -1;
        minus = 0; /*KS added to distinguish between '-' in filename and '-' the operator*/
        switch (currentToken) {
			case LX_IDENTIFIER:
				if (almost_equals(yytext2,"d$ata") ||
					almost_equals(yytext2,"po$ints")) {
					id1 = ID_OF_VALDATA; /* default to data():.. */
					parse_id(&id1, NULL);
					currentToken = parse_data(id1);
				} else if (almost_equals(yytext2, "vario$gram")) {
					parse_id(&id1, &id2);
					if (id1 == -1 && id2 == -1) {
						strcpy(gerr_text,lex_error2());
                        strcat(gerr_text,"missing identifier(s)");
						ErrMsg(ER_SYNTAX, gerr_text);
                    //KS    ErrMsg(ER_SYNTAX, "missing identifier(s)");
					}
					if (id2 == -1)
						currentToken = parse_variogram(id1,id1);
					else
						currentToken = parse_variogram(id1,id2);
				} else if (almost_equals(yytext2, "me$thod")) {
					CHECK;
					parse_method();
				} else if (almost_equals(yytext2, "bl$ocksize")) {
					currentToken = parse_block();
				} else if (almost_equals(yytext2, "area")) {
					CHECK;
					currentToken = parse_data(ID_OF_AREA);
				} else if (almost_equals(yytext2, "est$imates")
						||almost_equals(yytext2, "pr$edictions")) {
					parse_id(&id1, NULL);
					currentToken = parse_est(id1);
				} else if (almost_equals(yytext2, "var$iances")) {
					parse_id(&id1, NULL);
					currentToken = parse_var(id1,id2);
				} else if (almost_equals(yytext2,"cov$ariances")) {
					parse_id(&id1, &id2);
					currentToken = parse_var(id1,id2);
				} else if (almost_equals(yytext2, "mas$ks")) {
					CHECK;
					currentToken = parse_mask();
				} else if (almost_equals(yytext2, "mar$ginals")) {
					CHECK;
					currentToken = parse_marginals();
				} else if (almost_equals(yytext2, "bo$unds")) {
					CHECK;
					currentToken = parse_bounds(0);
				} else if (almost_equals(yytext2, "s$et"))
					currentToken = parse_set(0);
					else currentToken = parse_set(currentToken);
				break;
			case LX_WS: break;
			case LX_SEMICOLON: break;
			default:
				strcpy(gerr_text,lex_error2());
                strcat(gerr_text, yytext2);
			//KS	ErrMsg(ER_SYNTAX,  yytext2);
                //ErrMsg(ER_SYNTAX,  yytext2);
				ErrMsg(ER_SYNTAX,  gerr_text); //this is what you probably wanted to do CLogon
				break;
		} /* switch (currentToken) */
		if (currentToken != LX_WS && currentToken != LX_SEMICOLON) {
			/* "eat" the semicolon: */
			if (yylex2() != LX_SEMICOLON) {
                strcpy(gerr_text,lex_error2());
                strcat(gerr_text," `;' expected");
                ErrMsg(ER_SYNTAX, gerr_text);
			//KS	ErrMsg(ER_SYNTAX, " `;' expected");
			}
		}
	} /* while () */
	if (loc_gl_n > -1 && loc_gl_n != get_n_vars())
		ErrMsg(ER_SYNTAX, "define all data(..) before output options");
	set_lex_source2(NULL, NULL);
	if (boundary_file) {// != NULL) {
		cp = string_file(boundary_file);
		set_lex_source2(cp, boundary_file);
		parse_bounds(1);
        set_lex_source2(NULL, NULL);
	}
	efree(cp);
	return 0;
}

static int parse_id(int *id1, int *id2) {
/*
 * a sequence like `(var1)' or `(var1,var2)'
 * if id2==NULL, only the first one may occur, else both
 */
	int yy, state = 0;
    //char *err_text = NULL; /*KS added*/
	/*
	 * state 0: entry, get `(' ;
	 * 1: get `)' or identifier;
	 * 2: get `,' (if id2)
	 * 3: get second identifier;
	 * 4: get `)'
	 * default: do not reach
	 */
    //err_text = (char *)emalloc(80); /*KS added*/

	while ((yy = yylex2()) != LX_COLON) {
    	switch (state) {
			case 0:
				switch (yy) {
					case LX_WS:
						break;
					case LX_LB:
						state = 1;
						break;
					default:
						strcpy(gerr_text,lex_error2());
                        strcat(gerr_text,"`(' expected");
                        ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "`(' expected");
						break;
				}
				break;
			case 1:
				switch (yy) {
					case LX_WS:
						break;
					case LX_RB:
						state = 5;
						break;
					case LX_IDENTIFIER:
						*id1 = which_identifier(yytext2);
						state = 2;
						break;
					default:
						strcpy(gerr_text,lex_error2());
                        strcat(gerr_text,"identifier or `)' expected");
                        ErrMsg(ER_SYNTAX, gerr_text);
					//	ErrMsg(ER_SYNTAX, "identifier or `)' expected");
						break;
				}
				break;
			case 2:
				switch (yy) {
					case LX_WS:
						break;
					case LX_RB:
						state = 5;
						break;
					case LX_COMMA:
						state = 3;
						if (id2 != NULL)
							break; /* else FALLTHROUGH if id2 == NULL */
					default:
						strcpy(gerr_text,lex_error2());
						if (id2 != NULL) {
                        	strcat(gerr_text, "`,' or `)' expected");
                        	ErrMsg(ER_SYNTAX, gerr_text);
						//KS	ErrMsg(ER_SYNTAX, "`,' or `)' expected");
                            }
						else {
                        	strcat(gerr_text, "`)' expected");
                        	ErrMsg(ER_SYNTAX, gerr_text);
						//KS	ErrMsg(ER_SYNTAX, "`)' expected");
                            }
						break;
				}
				break;
			case 3:
				switch (yy) {
					case LX_WS:
						break;
					case LX_IDENTIFIER:
						*id2 = which_identifier(yytext2);
						state = 4;
						break;
					default:
						strcpy(gerr_text,lex_error2());
                        strcat(gerr_text,"identifier expected");
                        ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "identifier expected");
						break;
				}
				break;
			case 4:
				switch (yy) {
					case LX_WS:
						break;
					case LX_RB:
						state = 5;
						break;
					default:
						strcpy(gerr_text,lex_error2());
                        strcat(gerr_text,"`)' expected");
                        ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "`)' expected");
						break;
				}
				break;
			default:
				strcpy(gerr_text,lex_error2());
                strcat(gerr_text,"`:' expected");
                ErrMsg(ER_SYNTAX, gerr_text);
			//KS	ErrMsg(ER_SYNTAX, "`:' expected");
				break;
		}
	}
	if (state != 5) {
		strcpy(gerr_text,lex_error2());
        strcat(gerr_text,"missing or incomplete identifier(s)");
        ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, "missing or incomplete identifier(s)");
	}
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_data(int id) {
/*
 * parse a sequence like ``  'file.dat', x=1,y=2,v=4,log;  ''
 */
	int type = 0, yy = -1, state = 0;
	void *p = NULL;
	DATA **data = NULL, *d = NULL;
    int c,i; /*KS added*/
    bool readname;/*KS added*/
    double sk_mean;

	/*
	 * state: 0 if in start -> 1 or 0
	 * 1 if LX_IDENTIFIER has passed -> 2 or 3 (X=...)
	 * 2 if LX_EQ has passed -> 0
	 * 3 if , or ; passed -> 0
	 */
	switch (id) {
		case ID_OF_VALDATA:
			d = get_dataval();
			d->id = ID_OF_VALDATA;
			break;
		case ID_OF_AREA:
			create_data_area();
			d = get_data_area();
			d->id = ID_OF_AREA;
			break;
		default:
			data = get_data();
            d = data[id];
			d->id = id; /* yes ! */
			break;
	}

    //err_text = (char *)emalloc(80); /*KS added*/
    readname = 0; /*KS added*/

	while ((yy = yylex2()) != LX_SEMICOLON) {
    	if (almost_equals(yytext2, "dummy")) {
					d->dummy = 1; state = 0;
                    }
		switch (state) {
			case 0:
//				if (yy == LX_COMMA || (yy == LX_WS && readname))  /*KS added readname for filenames with blank spaces*/
//  				    break;
                if (yy == LX_COMMA) {
                    readname = 1;
                    break;
                    }
                if ((yy == LX_WS) && !readname) { /*KS added section to deal with spaces*/
                    if (!d->fname)
                    	{if (strlen(yytext2) > 0) {
                        	d->fname = unquote_dup(yytext2);
                            }
                        }
                    else {
                        d->fname = (char *) erealloc(d->fname,strlen(d->fname)+2);
                        strcat(d->fname," ");
                        }
                    break;
                    } else if (yy == LX_WS) break;
				if ((yy == 4/*LX_STRING*/) || (yy == LX_IDENTIFIER && !readname) || (yy == 1/*LX_INT*/ && !readname)) {
                    c = *yy_Source;
    				if (c == 45) {                 /*KS added section to accept "-" dash in filenames*/
                    	i = strlen(yytext2);
                        yytext2[i+1] = *yy_Source;
                    	yy_Source++;
                        c = *yy_Source;
                        while (isalnum(c) && (*yy_Source != EOF) || (c == 95) || (c == 46) || (c == 45) || (c == 32)) {
            				yytext2[i] = *yy_Source;
            				yy_Source++;
            				c = *yy_Source;
            				i++;
            			}
                     }
                    if (!d->fname)  d->fname = unquote_dup(yytext2);
                    else {
//                    	tmpname = unquote_dup((const char *)yytext2);
                    	d->fname = (char *) erealloc(d->fname,strlen(d->fname)+strlen(yytext2)+1);
                    	strcat(d->fname,yytext2);
                        }
					break;
				}
				if (yy != LX_IDENTIFIER) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "keyword expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "keyword expected");
				}
				p = NULL;
				type = 0;
				state = 1;
				if        (almost_equals(yytext2, "x")) {
					p = &(d->colnx);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "y")) {
					p = &(d->colny);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "z")) {
					p = &(d->colnz);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "V")) {
					p = &(d->colnvariance);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "v")) {
					p = &(d->colnvalue);
					type = 1/*LX_INT*/;
				} else if (d->id == ID_OF_VALDATA &&
					almost_equals(yytext2, "s$tratum")) {
					d->what_is_u = 3;/*U_ISSTRATUM;*/
					p = &(d->colns);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "max")) {
					p = &(d->sel_max);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "min")) {
					p = &(d->sel_min);
					type = 1/*LX_INT*/;
                } else if (almost_equals(yytext2, "omax")) {
					p = &(d->oct_max);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "n$max")) {
					p = &(d->init_max);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "d")) {
					p = &(d->polynomial_degree);
					type = 1/*LX_INT*/;
				} else if (almost_equals(yytext2, "r$adius")) {
					p = &(d->sel_rad);
					type = 3/*LX_REAL*/;
				} else if (almost_equals(yytext2, "dX")) {
					p = &(d->dX);
					type = 3/*LX_REAL*/;
				} else if (almost_equals(yytext2, "mv")) {
					p = &(d->mv);
					type = 3/*LX_REAL*/;
				} else if (almost_equals(yytext2, "I")) {
					p = &(d->Icutoff);
					type = 3/*LX_REAL*/;
				} else if (almost_equals(yytext2, "sk_mean")) {
                    sk_mean = -9999.0; /*KS added sk_mean*/
					d->beta = push_to_vector(sk_mean, d->beta);  /*KS*/
                    p = &(d->beta->val[0/*id*/]);
                    //state = 0;  p = NULL;
					type = 3/*LX_REAL*/;
				} else if (almost_equals(yytext2, "mean")) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "use `sk_mean' instead of `mean'");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "use `sk_mean' instead of `mean'");
				} else if (almost_equals(yytext2, "av$erage")) {
					d->average = 1; state = 0;
				} else if (almost_equals(yytext2, "noav$erage")) {
					d->average = 0; state = 0;
				} else if (almost_equals(yytext2,"res$iduals")) {
					d->calc_residuals = 1; state = 0; resid = 1;
				} else if (almost_equals(yytext2,"nor$esiduals")) {
					d->calc_residuals = 0; state = 0; resid = 0;
				} else if (almost_equals(yytext2, "sq$uare")) {
					d->square = 1; state = 0;
				} else if (almost_equals(yytext2, "log")) {
					d->log = 1; state = 0;
				} else if (almost_equals(yytext2, "dummy")) {
					d->dummy = 1; state = 0;
				} else if (almost_equals(yytext2, "st$andard")) {
					d->standard = 1; state = 0;
				} else if (almost_equals(yytext2, "fo$rcemin")) {
					d->force = 1; state = 0;
				} else if (almost_equals(yytext2, "vd$ist")) {
					d->vdist = 1; state = 0;
				} else if (almost_equals(yytext2, "X")) {
					state = 3;  /* special case, e.g. "X=3&4" */
				/* what else?? */
				} else {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "unknown keyword");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "unknown keyword");
				}
				break;
			case 1:
				if (yy == LX_WS)
					break;
				if (yy != LX_EQ) {
					strcpy(gerr_text,lex_error2());                
                    strcat(gerr_text, " `=' expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, " `=' expected");
				}
				state = 2;
				break;
			case 2:
				if (yy == LX_WS)
					break;
				switch(type) {
					case 1/*LX_INT*/:
						if (yy != 1/*LX_INT*/ ||
								read_int(yytext2, (int *)p)) {
							strcpy(gerr_text,lex_error2());
                    		strcat(gerr_text,  yytext2);
                    		ErrMsg(ER_RDINT, gerr_text);
						//KS	ErrMsg(ER_RDINT,  yytext2);
						}
						break;
					case 3/*LX_REAL*/:
						if ((yy != 1/*LX_INT*/ && yy != 3/*LX_REAL*/) ||
								read_double(yytext2, (double *)p)) {
							strcpy(gerr_text,lex_error2());
                    		strcat(gerr_text,  yytext2);
                    		ErrMsg(ER_RDFLT, gerr_text);
						//KS	ErrMsg(ER_RDFLT,  yytext2);
						}
						break;
					default:
						strcpy(gerr_text,lex_error2());
                        strcat(gerr_text, "unknown type");
                    	ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "panic! unknown type");
						break;
				}
				state = 0; /* back to normal */
//				p = NULL;
				break;
			case 3:
				if (yy == LX_WS)
					break;
				if (yy != LX_EQ) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, " `=' expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, " `=' expected");
				}
				yy = parse_data_X(d);
				if (yy == LX_SEMICOLON)
					return yy;
				state = 0; /* when yy == LX_COMMA */
				break; /* from state 3 */
			default:
				ErrMsg(ER_IMPOSVAL, "parse_data()");
		} /* switch state */
	} /* while */
    
    if (d->mv != 0.0)
    	default_misval_idrisi = d->mv;           /*KS added*/
    //efree(err_text);/*KS added*/
	return yy;
} /* parse_data() */

static int parse_data_X(DATA *d) {
	int state = 0, i, yy;
    //char *err_text = NULL; /*KS added*/

    //err_text = (char *) emalloc(64); /*KS added*/
	while ((yy = yylex2()) != LX_COMMA && yy != LX_SEMICOLON) {
		switch (yy) {
			case LX_WS:
				break;
			case 1/*LX_INT*/:
				if (state != 0) {
                    strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "no integer expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "no integer expected");
				}
				if (read_int( yytext2, &i)) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text,  yytext2);
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_RDINT,  yytext2);
				}
				if (i < -1) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "only values >= -1 accepted");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "only values >= -1 accepted");
				} else if (i == -1) { /* remove default intercept */
					if (d->n_X > 1) {
						strcpy(gerr_text,lex_error2());
                    	strcat(gerr_text, "-1 only as first argument");
                    	ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "-1 only as first argument");
					}
					d->n_X = 0;
				} else if (i == 0) {
						strcpy(gerr_text,lex_error2());
                    	strcat(gerr_text, "intercept is default");
                    	ErrMsg(ER_SYNTAX, gerr_text);
					//KS    ErrMsg(ER_SYNTAX, "intercept is default");
				} else /* i > 0 */
					data_add_X(d, i);
				state = 1;
				break;
			case LX_IDENTIFIER:
				for (i = 0; i < 18/*N_POLI*/; i++) {
					if (almost_equals(yytext2, polynomial[i].name)) {
						i += -19/*POLI_MIN*/;
						break; /* i-loop */
					}
				}
				if (i > 0) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "Only allowed are: x, y, z, xy, x2,...");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "Only allowed are: x, y, z, xy, x2,...");
				}
				data_add_X(d, i);
				state = 1;
				break;
			case LX_AMPERSAND:
				if (state != 1) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, "``&'' not expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "``&'' not expected");
				}
				state = 0;
				break;
			default:
				strcpy(gerr_text,lex_error2());
				if (state == 0) {
                	strcat(gerr_text, "integer or x,y,x2,... expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "integer or x,y,x2,... expected");
                    }
				else {
                	strcat(gerr_text, " `&', `,' or `;' expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, " `&', `,' or `;' expected");
                	}
				break;
		}
	}
    //efree(err_text); /*KS added*/
	return yy;
}

int read_variogram(VARIOGRAM *v, char *source, int id) {
/*
 * read_variogram() returns < 0 at error;
 * returns last returned yylex() value (0 or LX_SEMICOLON) on normal exit
 * LALR(1) parser of variogram structure contained in source, or in yy_Source
 * if source == NULL.
 * state: 0: expecting sill or range, or `)' in case  of Nug(), Int().
 *        1: expecting identifier: Sph, Nug, Exp, Gau etc.
 *        2: expecting the comma-separated anis. values, or
 *           ')' (end of range or anisotropy)
 * at the end of a structure (the `)' closing the range) the model part is
 * added to the variogram structure, and re-initialised.
 */
	int state = 0, /* current state */ yy = -1, i = 0,
		anis = -1, /* holds current position in d[], -1 if no anisotropy */
		reading_sill = 1; /* busy reading sill (1) or range (0) */
	double d[5]; /* hold currently parsed anisotropy parameters (sill/range) */
	//VGM_MODEL *part; /* hold currently parsed variogram model part */
    VGM_MODEL PartStruct; //part;
    VGM_MODEL *part = &PartStruct;
    init_variogram_part(part);
    //char *err_text2 = NULL;

	if (!v)
		ErrMsg(ER_NULL, "read_variogram()");
	if (source!= NULL)
		set_lex_source2(source, NULL);
	v->n_models = v->n_fit = 0;
	//init_variogram_part(part); /*KS removed*/
    minus = 1;/*KS added to distinguish between '-' in filename and '-' the operator*/
    //err_text2 = (char *) emalloc(128); /*KS added*/
	while ((yy = yylex2()) != 0 && (yy != LX_SEMICOLON)) {
#ifdef LDEBUG
		printf("state %d, yytext2: [%s]\n", state, yytext2);
#endif
		switch (state) {
			case 0:  /* start of variogram model */
				d[0] = 0.0; d[1] = 0.0; /*KS broke apart*/
                d[2] = 0.0; d[3] = 1.0;
                d[4] = 1.0;
				switch(yy) {
					case LX_WS: break;
					case LX_AT:
						if (reading_sill)
							part->fit_sill = 0;
						else
							part->fit_range = 0;
						break;
					case LX_LB:
						if (reading_sill)
							anis = 0;
						break;
					case LX_RB: /* Nug(), Int() */
						if (reading_sill == 0) {
							part->range = 0.0;
							push_model(v, *part, id);
							init_variogram_part(part);
							reading_sill = 1;
							anis = -1;
						} else {
							pr_warning("real value expected before `)'");
                            //efree(err_text2);
							return -1;
						}
						break;
					case LX_PLUS: break;
                    case LX_MINUS: break;
					case 1/*LX_INT*/:
					case 3/*LX_REAL*/:
						if (reading_sill ? read_double(yytext2, (&(part->sill))) : read_double(yytext2,(&(part->range))))
                        {
                            sprintf(gerr_text,"error reading float from `%s'", yytext2);
							pr_warning(gerr_text);
                            //efree(err_text2);
							return -1;
						}
						if (anis == -1 && reading_sill)
							state = 1;
						else
							state = 2;
						break;
					default:
                        sprintf(gerr_text,"syntax error: %s", yytext2);
						pr_warning(gerr_text);
                        //efree(err_text2);
						return -1;
				}
				break;
			case 1:  /* next is ID, or +, -, real if intercept */
				switch (yy) {
					case LX_WS: break;
					case LX_PLUS:
						part->model = INTERCEPT;
						push_model(v, *part, id);
						init_variogram_part(part);
						anis = -1;
						state = 0;
						break;
					case 1/*LX_INT*/:
					case 3/*LX_REAL*/:
						part->model = INTERCEPT;
						push_model(v, *part, id);
						init_variogram_part(part);
						anis = -1;
						if (read_double(yytext2, &(part->sill))) {
                            sprintf(gerr_text,"error reading float from `%s'", yytext2);
							pr_warning(gerr_text);
                            //efree(err_text2);
							return -1;
						}
						state = 1;
						break;
					case LX_IDENTIFIER:
						for (i = 0; i < strlen(  yytext2); i++)
							yytext2[i] = toupper( (int) yytext2[i]);
						part->model = which_model( yytext2);
						if (part->model == NOT_SP) {
                            sprintf(gerr_text,"syntax error: unknown variogram model: %s",yytext2);
							pr_warning(gerr_text);
                            //efree(err_text2);
							return -1;
						}
						reading_sill = 0;
						state = 0;
						break;
					default:
                        sprintf(gerr_text,"syntax error: variogram model expected %s",yytext2);
						pr_warning(gerr_text);
                        //efree(err_text2);
						return -1;
				}
				break;
			case 2:  /* read rest of anisotropy: ) or a,a) or a,a,a,a,a) */
				switch (yy) {
					case LX_WS: break;
					case LX_COMMA:
						if (anis < 0)
							anis = 0;
						break;
					case LX_RB: /* push anisotropy model */
						switch (anis) {
							case -1: break;
							case 2: /* RB comes after two reals are read */
								d[3] = d[1]; /* angle ratio */
								d[1] = d[2] = 0.0;
								d[4] = 1.0; /* BREAKTHROUGH: */
							case 5:
								if (reading_sill) {
									pr_warning("no anisotropy allowed in sill");
                                    //efree(err_text2);
									return -1;
								} else
									part->tm_range = get_tm(d);
								break;
							default:
								pr_warning("anisotropy has 2 or 5 parameters");
                                //efree(err_text2);
								return -1;
						}
						if (reading_sill == 0) {
							push_model(v, *part, id);
							init_variogram_part(part);
							reading_sill = 1;
							state = 0;
							anis = -1;
						}
						break;
					case 1/*LX_INT*/: /* BREAKTRHOUGH */
					case 3/*LX_REAL*/:
						if (anis < 0 || anis > 4) {
							pr_warning("anisotropy has 2 or 5 parameters");
                            //efree(err_text2);
							return -1;
						}
						if (read_double(yytext2, &(d[anis]))) {
                            sprintf(gerr_text,"error reading float from `%s'", yytext2);
							pr_warning(gerr_text);
                            //efree(err_text2);
							return -1;
						}
#ifdef LDEBUG
						printf("reading anis %d : %g\n", anis, d[anis]);
#endif
						anis++;
						break;
					default:
                        sprintf(gerr_text,"syntax error real expected %s", yytext2);
						pr_warning(gerr_text);
                        //efree(err_text2);
						return -1;
				}
				break;
			default:
				pr_warning("unknown state");
                //efree(err_text2);
				return -1;
		} /* switch state */
	} /* while */
	update_variogram(v); /* fills v->descr, min/sum/max */
	if (state != 0) {
        sprintf(gerr_text,"variogram descriptor [%s] not complete (state %d)",
			v->descr, state);
		pr_warning(gerr_text);
        //efree(err_text2);
		return -1;
	}
	if (source) /*!= NULL*)/ /* close parser: */
		set_lex_source2(NULL, NULL);
    //efree(err_text2);
	return yy;
} /* read_variogram */

/*KS replaced all lex_error() with err_text=lex_error() and modified ErrMsg*/
static void reset_lex2(void) {
	yy_Lexpos = 0;
	new_source = 1;
	yy_Posafternl = 1;
	My_yy_lineno = 1;
}

void set_lex_source2(/*const*/ char *source, const char *fname) { /*KS removed const*/
/*
 * initialize sources:
 */
	reset_lex2();
    if (!yy_Source)
        yy_Source = (char *) emalloc(strlen(source)); /*KS added*/
	yy_Source = source;
	if (!yy_File_name)
        yy_File_name = (char *) emalloc(strlen(fname)); /*KS added*/
    yy_File_name = fname;
    }

char *lex_error2(void) {                 /*KS replace with older version 1/18/99*/
/*
 * make error position indication message like:
 * points(zn): xx=1, y=2, v=3;
 *             ^^
 */
	int i = 0;
    char buff[60]; //char *err_text;
    FillMemory(gerr_text, ERR_TEXT_SIZE, 0);//memset(gerr_text,0,ERR_TEXT_SIZE);
    char* tmpl = gerr_text;

	/* print current line, \t -> ' ' */
    //err_text = (char *)emalloc(48); /*KS added*/
	if (lastnl != NULL && strlen(lastnl) > 0) {
		while (lastnl[i] != '\n' && lastnl[i] != '\0') {
		//KS 	fprintf(stderr, "%c",lastnl[i] == '\t' ? ' ' : lastnl[i]);
        	tmpl[i] = lastnl[i] == '\t' ? ' ' : lastnl[i];
			i++;
		}
    }
	switch (*yytext2) {
		case '\0':
            strcat(tmpl," unexpected end of file ");
			break;
		case '\n':
            strcat(tmpl," unexpected end of line ");
			break;
		default:
           sprintf(buff,"%s unexpected, ",(char *) yytext2);
           strcat(tmpl,buff);
	}
	return tmpl;
}

int yylex2(void) {		/*KS added missing function */
    int c,i = 1;

    for (c=0; c<79; c++) yytext2[c] = NULL;
    c = *yy_Source;
    if ((c == 45) && minus) {
        yy_Source++;
    	return LX_MINUS;
        }
    if ((isdigit(c)) || (c == 46)  || (c == 45)) {
    	 if (c == 45) {
         		yytext2[0] = char(c);
                yy_Source++; c = *yy_Source;
                if (isdigit(c)) {
                    yytext2[i] = *yy_Source;
            	//	c = *yy_Source;
            		i++;
         		}
         } else yytext2[0] = char(c);

         while (isdigit(c)) {
         	yy_Source++;
            c = *yy_Source;
            yytext2[i] = *yy_Source;
            i++;
            }
         if (c == 46) {
         	yy_Source++;
            c = *yy_Source;
            yytext2[i] = *yy_Source;
            i++;
         	while (isdigit(c)) {
         		yy_Source++;
            	c = *yy_Source;
            	yytext2[i] = *yy_Source;
                i++;
         	}
            yytext2[i-1] = NULL;
            return 3/*LX_REAL*/;
        }
        yytext2[i-1] = NULL;
        return 1/*LX_INT*/;
    }
    /* if c == ' , " */
    if ((c == 39) || (c == 34)) {
        yy_Source++;
        c = *yy_Source;
        yytext2[0] = char(c);

     	while (isalnum(c) && (*yy_Source != EOF) || (c == 95) || (c == 46) || (c == 58) || (c == 92)) {
            yy_Source++;
            yytext2[i] = *yy_Source;
            c = *yy_Source;
            while ((c == 32) || (c == 45)) {
                 i++; yy_Source++; yytext2[i] = *yy_Source; c = *yy_Source;
            }
            i++;
            }
        //c = yytext2[0];
        if ((c == 39) || (c == 34) || (c == 41) || (c ==45)) {
        	if (c != 45) yy_Source++;
        	return 4/*LX_STRING*/;
        }
   }
   /* if c == letter, digit, or _ */  /*filenames cannot start with digits but have digits in their names*/
   if ((isalnum(c)) || (c == 95)) {
        yytext2[0] = char(c);
        yy_Source++;
        c = *yy_Source;
   /*      if ((c == 39) || (c == 34)) {
        	yy_Source++;
            c = *yy_Source;
            yytext2[i] = *yy_Source;
            i++;
            } */
        while (isalnum(c) && (*yy_Source != EOF) || (c == 95) || (c == 46)) {
            yytext2[i] = *yy_Source;
            yy_Source++;
            c = *yy_Source;
            i++;
            }
   /*     c = yytext2[0];
        if ((c == 39) || (c == 34)) {
        	yy_Source++;
        	return 4/*LX_STRING*///;
 //       }*/
   //     yytext2[i-1] = NULL;
        return LX_IDENTIFIER;
   }
   else if (c == 35) {
        while (*yy_Source != '\n') {
            yy_Source++;
            c = *yy_Source;
        }
        yy_Source++;
        return LX_WS;
    }
  else if (isspace(c)) {
    yy_Source++;
  	return LX_WS;
  }
 else if (c == 44) {
    yy_Source++;
    return LX_COMMA;
 }
else
yy_Source++;
return c;
}


static void push_model(VARIOGRAM *v, VGM_MODEL part,int id) {
	if (v->n_models == v->max_n_models) {
		v->max_n_models *= 2;
		v->part = (VGM_MODEL *)
			erealloc(v->part, v->max_n_models * sizeof(VGM_MODEL));
	}
	/*
	 * check some things:
	 */
	if (part.model == NOT_SP)
		ErrMsg(ER_IMPOSVAL, "model NSP not allowed in variogram structure");
	if (part.range < 0)
		ErrMsg(ER_RANGE, "variogram range cannot be negative");
	if (part.model == LINEAR) {
		if (part.range == 0.0)
			part.fit_range = 0;
	} else if (part.model == NUGGET || part.model == INTERCEPT) {
		part.fit_range = 0;
		if (part.range > 0.0)
			ErrMsg(ER_RANGE, "range must be zero");
	} else if (part.range == 0.0)
		ErrMsg(ER_RANGE, "range must be positive");
	if (part.model == POWER && part.range > 2.0)
		ErrMsg(ER_RANGE, "power model can not exceed 2.0");
	v->part[v->n_models] = part;
	if (v->isotropic)
		v->isotropic = (part.tm_range == NULL);
	if (part.model == BESSEL || part.model == GAUSSIAN ||
			part.model == EXPONENTIAL || part.model == LOGARITHMIC ||
			part.model == POWER || part.model == PERIODIC ||
			(part.model == LINEAR && part.range == 0))
				/* sill is reached asymptotically or oscillates */
		v->max_range = FLT_MAX;
	else  /* transitive model: */
		v->max_range = MAX(part.range, v->max_range);
	v->part[v->n_models].da_fnct = NULL; /* initialize */
 switch (part.model) {
  		case NUGGET:
			v->part[v->n_models].fnct = fn_nugget;
			v->part[v->n_models].da_fnct = da_is_zero;
			break;
  		case LINEAR:
			v->part[v->n_models].fnct = fn_linear;
			v->part[v->n_models].da_fnct = da_fn_linear;
			break;
  		case CIRCULAR:
			v->part[v->n_models].fnct = fn_circular;
			break;
  		case SPHERICAL:
			v->part[v->n_models].fnct = fn_spherical;
			v->part[v->n_models].da_fnct = da_fn_spherical;
			break;
  		case PENTASPHERICAL:
			v->part[v->n_models].fnct = fn_pentaspherical;
			v->part[v->n_models].da_fnct = da_fn_pentaspherical;
			break;
  		case BESSEL:
			v->part[v->n_models].fnct = fn_bessel;
			break;
  		case GAUSSIAN:
			v->part[v->n_models].fnct = fn_gaussian;
			v->part[v->n_models].da_fnct = da_fn_gaussian;
			break;
  		case EXPONENTIAL:
			v->part[v->n_models].fnct = fn_exponential;
			v->part[v->n_models].da_fnct = da_fn_exponential;
			break;
  		case PERIODIC:
			v->part[v->n_models].fnct = fn_periodic;
			v->part[v->n_models].da_fnct = da_fn_periodic;
			break;
  		case HOLE:
			v->part[v->n_models].fnct = fn_hole;
			v->part[v->n_models].da_fnct = da_fn_hole;
			break;
  		case LOGARITHMIC:
			v->part[v->n_models].fnct = fn_logarithmic;
			v->part[v->n_models].da_fnct = da_fn_logarithmic;
			break;
  		case POWER:
			v->part[v->n_models].fnct = fn_power;
			v->part[v->n_models].da_fnct = da_fn_power;
			break;
  		case INTERCEPT:
			v->part[v->n_models].fnct = fn_intercept;
			v->part[v->n_models].da_fnct = da_is_zero;
			break;
		default: /* impossible */
		break;
	}
	v->n_models++;
	return;
}

static VGM_MODEL_TYPE which_model(const char *m) {
  if (almost_equals(m, "NUG$GET")) return NUGGET;
  if (almost_equals(m, "LIN$EAR")) return LINEAR;
  if (almost_equals(m, "CIR$CULAR")) return CIRCULAR;
  if (almost_equals(m, "SPH$ERICAL")) return SPHERICAL;
  if (almost_equals(m, "BES$SEL")) return BESSEL;
  if (almost_equals(m, "GAU$SSIAN")) return GAUSSIAN;
  if (almost_equals(m, "EXP$ONENTIAL")) return EXPONENTIAL;
  if (almost_equals(m, "PEN$TASPHERICAL")) return PENTASPHERICAL;
  if (almost_equals(m, "PER$IODIC")) return PERIODIC;
  if (almost_equals(m, "HOL$E")) return HOLE;
  if (almost_equals(m, "LOG$ARITHMIC")) return LOGARITHMIC;
  if (almost_equals(m, "POW$ER")) return POWER;
  if (almost_equals(m, "INT$ERCEPT")) return INTERCEPT;
  return NOT_SP;
}

static ANIS_TM* get_tm(double anis[5]) {
	double alpha, beta, theta, sina, sinb, sint, cosa, cosb, cost, afac1, afac2;
	ANIS_TM *t = NULL;
    //char *err_text = NULL;

    //err_text = (char *) emalloc(40);
    /*KS changed message to pr_warning in #define*/
    #define ANIS_ERR(x) sprintf(gerr_text,"parsing anis(%g,%g,%g,%g,%g), error on %g\n", \
	anis[0],anis[1],anis[2],anis[3],anis[4],x)
	if (anis[0] < 0 || anis[0] >= 360) {
		ANIS_ERR(anis[0]);
        pr_warning(gerr_text);
		ErrMsg(ER_RANGE, "this value should be in [0..360>");
	}
	if (anis[1] < 0 || anis[1] >= 360) {
		ANIS_ERR(anis[1]);
        pr_warning(gerr_text);
		ErrMsg(ER_RANGE, "this value should be in [0..360>");
	}
	if (anis[2] < 0 || anis[2] >= 360) {
		ANIS_ERR(anis[2]);
        pr_warning(gerr_text);
		ErrMsg(ER_RANGE, "this value should be in [0..360>");
	}
	if (anis[3] <= 0 || anis[3] > 1) {
		ANIS_ERR(anis[3]);
        pr_warning(gerr_text);
		ErrMsg(ER_RANGE, "this value should be in <0..1]");
	}
	if (anis[4] <= 0 || anis[4] > 1) {
		ANIS_ERR(anis[4]);
        pr_warning(gerr_text);
		ErrMsg(ER_RANGE, "this value should be in <0..1]");
	}
	/* from DEUTSCH: */
	if (anis[0] >= 0.0 && anis[0] < 270)
		alpha = (double) (90.0 - anis[0]) * DEG2RAD;
	else
		alpha = (double) (450.0 - anis[0]) * DEG2RAD;
	beta = -1.0 * (double) anis[1] * DEG2RAD;
	theta =       (double) anis[2] * DEG2RAD;

	sina = sin(alpha);
	sinb = sin(beta);
	sint = sin(theta);
	cosa = cos(alpha);
	cosb = cos(beta);
	cost = cos(theta);

	afac1 = 1.0 / MAX((double) anis[3], (double) EPSILON);
	afac2 = 1.0 / MAX((double) anis[4], (double) EPSILON);

    t = (ANIS_TM *) emalloc(sizeof(ANIS_TM));

	t->angle[0] = anis[0];
	t->angle[1] = anis[1];
	t->angle[2] = anis[2];
	t->ratio[0] = anis[3];
	t->ratio[1] = anis[4];
	t->tm[0][0] =       (cosb * cosa);
	t->tm[0][1] =       (cosb * sina);
	t->tm[0][2] =       (-sinb);
	t->tm[1][0] = afac1*(-cost*sina + sint*sinb*cosa);
	t->tm[1][1] = afac1*(cost*cosa + sint*sinb*sina);
	t->tm[1][2] = afac1*( sint * cosb);
	t->tm[2][0] = afac2*(sint*sina + cost*sinb*cosa);
	t->tm[2][1] = afac2*(-sint*cosa + cost*sinb*sina);
	t->tm[2][2] = afac2*(cost * cosb);

    //efree(err_text);
	return t;
}

static int parse_variogram(int id1, int id2) {
/*
 * parse a sequence like `0.5nug() + 1sph(10)'
 */
	VARIOGRAM **vp = NULL;
	int yy, id = 0;
    char *null_text = NULL; /*KS added*/

	id = LTI(id1,id2);
    vp = (VARIOGRAM **) emalloc(get_n_vgms() * sizeof(VARIOGRAM *));// erealloc(vp, get_n_vgms() * sizeof(VARIOGRAM *));/*KS added */
	vp[id] = get_vgm(id);
	vp[id]->id = id;
	vp[id]->id1 = id1;
	vp[id]->id2 = id2;
	if ((yy = read_variogram(vp[id], null_text,id)) < 0) {
        //err_text = (char *) emalloc(44); /*KS added*/
		strcpy(gerr_text,lex_error2());
        strcat(gerr_text, "wrong variogram syntax");
        ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, "wrong variogram syntax");
    	//efree(err_text); /*KS added*/
	}
	return yy;
}

static int parse_method(void) {
/*
 * parse one identifier: the method
 */
	int yy, i;
    //char *err_text = NULL; /*KS added*/

	if (get_method() != NSP)
		pr_warning("`method' in command file overrides `-m'");
	while ((yy = yylex2()) == LX_WS)
		; /* do nothing, "eat" the white space */
	if (yy != LX_IDENTIFIER) {
		lex_error2();
		ErrMsg(ER_SYNTAX, "method expected");
	}
	for (i = 0; NULL != methods[i].name; i++) {
		if (almost_equals(yytext2, methods[i].name)) {
			set_method((METHOD) i);
			return 0;
		}
	}
	if (almost_equals(yytext2, "cs")) { /* backw. comp. */
		set_method(GSI);
		return 0;
	}
    //err_text = (char *) emalloc(28); /*KS added*/
    strcpy(gerr_text,lex_error2());
    strcat(gerr_text,  "unknown method");
    ErrMsg(ER_SYNTAX, gerr_text);
//KS	ErrMsg(ER_SYNTAX, "unknown method");
	//efree(err_text); /*KS added*/
	return 0;
}

static int parse_block(void) {
/*
 * parse a sequence like `dx=1.0;', `dx=1,dy=2;' or `dx=10,dy=5,dz=9;'
 * denoting x-, [y-, [z-]] block dimensions
 */
	int state = 0, yy;
	DPOINT *bp = NULL;
	double *rp = NULL;
    //char *err_text = NULL; /*KS added*/

    //err_text = (char *) emalloc(54); /*KS added*/

	bp = get_block_p();
	bp->x = bp->y = bp->z = 0.0;
	if (( yy = yylex2() ) == LX_SEMICOLON) { /* the `blocks;' command */
		bp->x = -1.0; /* catch this one later on */
        //efree(err_text); /*KS added*/
		return yy;
	} else if (yy != LX_COLON) {
		strcpy(gerr_text,lex_error2());
    	strcat(gerr_text,  " `:' or `=' expected");
    	ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, " `:' or `=' expected");
	} /* go on with contents */
	while (( yy = yylex2() ) != LX_SEMICOLON) {
		switch (state) {
			case 0: if (yy == LX_WS || yy == LX_COMMA)
					break;
				if (yy != LX_IDENTIFIER) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text,"`dx', `dy' or `dz' expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "`dx', `dy' or `dz' expected");
				}
				if (almost_equals(yytext2, "dx")) {
					state = 1;
					rp = &(bp->x);
					break;
				}
				if (almost_equals(yytext2, "dy")) {
					state = 1;
					rp = &(bp->y);
					break;
				}
				if (almost_equals(yytext2, "dz")) {
					state = 1;
					rp = &(bp->z);
					break;
				}
				strcpy(gerr_text,lex_error2());
                strcat(gerr_text,"`dx', `dy' or `dz' expected");
                ErrMsg(ER_SYNTAX, gerr_text);
			//KS	ErrMsg(ER_SYNTAX, "`dx', `dy' or `dz' expected");
				break;
			case 1:
				if (yy == LX_WS)
					break;
				if (yy != LX_EQ) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text," `=' expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, " `=' expected");
				}
				state = 2;
				break;
			case 2:
				if (yy == LX_WS)
					break;
				if ((yy != 1/*LX_INT*/ && yy != 3/*LX_REAL*/)  ||
						read_double(yytext2, rp)) {
                	strcpy(gerr_text,lex_error2());
                    strcat(gerr_text, yytext2);
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_RDFLT,  yytext2);
				}
				if (*rp < 0.0) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text,"no negative value allowed");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_RANGE, "no negative value allowed");
				}
				state = 3;
				break;
			case 3:
				if (yy == LX_WS)
					break;
				if (yy != LX_COMMA) {
					strcpy(gerr_text,lex_error2());
                    strcat(gerr_text,"`,' or `;' expected");
                    ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "`,' or `;' expected");
				}
				state = 0;
				break;
		} /* switch (state) */
	}
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_est(int id) {
/*
 * parse one string;
 */
	char **cpp = NULL;
	int yy, done = 0;
    //char *err_text = NULL; /*KS added*/
    int c,i; /*KS added*/

/*KS*/ //err_text = (char *) emalloc(52); /*KS added*/

	cpp = (char **) get_outfile_name();
//	if (NULL != cpp[2 * id]) {
//		strcpy(gerr_text,lex_error2());
//        strcat(gerr_text,"file name was set before");
//        ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, "file name was set before");
//	}

	while ((yy = yylex2()) != LX_SEMICOLON) {
		switch (yy) {
			case LX_WS:
            	 /*KS added section to deal with spaces*/
                    if (!cpp[2 * id] && (strlen(yytext2) > 0)) {
                        cpp[2 * id] = (char *) emalloc(strlen(yytext2));
                        strcat(cpp[2 * id],yytext2);
                        } else if (cpp[2 * id]) {
                            cpp[2 * id] = (char *) erealloc(cpp[2 * id],strlen(cpp[2 * id])+2);
                            strcat(cpp[2 * id]," ");
                            }
				break;
            case LX_IDENTIFIER:   /*KS added*/
            case 1/*LX_INT*/: /*KS added*/
			case 4/*LX_STRING*/:
				if (done) {
					strcpy(gerr_text,lex_error2());
        			strcat(gerr_text,"one quoted string expected");
        			ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "one quoted string expected");
				}

                    c = *yy_Source;
    				if (c == 45) {                 /*KS added section to accept "-" dash in filenames*/
                    	i = strlen(yytext2);
                        yytext2[i-1] = *yy_Source;
                        yy_Source++;
                        c = *yy_Source;
                        while (isalnum(c) && (*yy_Source != EOF) || (c == 95) || (c == 46) || (c == 45)) {
            				yytext2[i] = *yy_Source;
            				yy_Source++;
            				c = *yy_Source;
            				i++;
            			}
                     }
                if (!cpp[2 * id]) cpp[2 * id] = unquote_dup( yytext2);
                        else {
                    	cpp[2 * id] = (char *) erealloc(cpp[2 * id],strlen(cpp[2 * id])+strlen(yytext2));
                    	strcat(cpp[2 * id],yytext2);
                        }
				//done = 1;  /*KS removed*/
				break;
			default:
				strcpy(gerr_text,lex_error2());
                strcat(gerr_text,"one quoted string expected");
        		ErrMsg(ER_SYNTAX, gerr_text);
			//KS	ErrMsg(ER_SYNTAX, "one quoted string expected");
				break;
		}
	}
    if (cpp[2 * id]) done = 1;   /*KS*/
	if (! done) {
		strcpy(gerr_text,lex_error2());
        strcat(gerr_text,"quoted string expected");
        ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, "quoted string expected");
	}
//    push_outfile_name(cpp[2*id],2*id);/*KS added*/
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_var(int id1, int id2) {
/*
 * parse one string;
 */
	char **cpp = NULL;
	int yy, done = 0, id;
    //char *err_text = NULL; /*KS added*/
    int c, i; /*KS added*/
/*KS*/ //err_text = (char *) emalloc(52); /*KS added*/

	cpp = (char **) get_outfile_name();

    if (id2 == -1)
    	id = 2 * id1 + 1;
		else {
			loc_gl_n = get_n_vars(); /* watch out */
			id = 2 * loc_gl_n + LTI2(id1, id2);
		}

	while ((yy = yylex2()) != LX_SEMICOLON) {
		switch (yy) {
			case LX_WS:
                /*KS added section to deal with spaces*/
                    if (!cpp[id] && (strlen(yytext2) > 0)) {
                        cpp[id] = (char *) emalloc(strlen(yytext2));
                        strcat(cpp[id],yytext2);
                        } else if (!cpp[id]) {}
                        	else {
                            cpp[id] = (char *) erealloc(cpp[id],strlen(cpp[id])+2);
                            strcat(cpp[id]," ");
                            }
				break;
            case LX_IDENTIFIER:    /*KS added*/
            case 1/*LX_INT*/:          /*KS added*/
			case 4/*LX_STRING*/:
				if (done) {
					strcpy(gerr_text,lex_error2());
        			strcat(gerr_text,"one quoted string expected");
 			        ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "one quoted string expected");
				}
				/*if (id2 == -1)
					id = 2 * id1 + 1;
				else {
					loc_gl_n = get_n_vars(); /* watch out */
				/*	id = 2 * loc_gl_n + LTI2(id1, id2);
				} *//*KS moved above*/
				/*if (cpp[id] != NULL) {
					strcpy(err_text,lex_error2());
        			strcat(err_text,"file name was set before");
 			        ErrMsg(ER_SYNTAX, err_text);
					ErrMsg(ER_SYNTAX, "file name was set before");
				} *//*KS removed even though this catch will not be made*/
                c = *yy_Source;
    				if (c == 45) {                 /*KS added section to accept "-" dash in filenames*/
                    	i = strlen(yytext2);
                        yytext2[i-1] = *yy_Source;
                        yy_Source++;
                        c = *yy_Source;
                        while (isalnum(c) && (*yy_Source != EOF) && (c != 39) || (c == 95) || (c == 46) || (c == 45)) {
            				yytext2[i] = *yy_Source;
            				yy_Source++;
            				c = *yy_Source;
            				i++;
            			}
                     }
                if (!cpp[id]) cpp[id] = unquote_dup(yytext2);
                        else {
                    	cpp[id] = (char *) erealloc(cpp[id],strlen(cpp[id])+strlen(yytext2));
                    	strcat(cpp[id],yytext2);
                        }
				//done = 1;      /*KS removed*/
				break;
			default:
				strcpy(gerr_text,lex_error2());
                strcat(gerr_text, "one quoted string expected");
 			    ErrMsg(ER_SYNTAX, gerr_text);
			//KS	ErrMsg(ER_SYNTAX, "one quoted string expected");
				break;
		}
	}
    if (cpp[id]) done = 1; /*KS*/
	if (! done) {
		strcpy(gerr_text,lex_error2());
        strcat(gerr_text, "quoted string expected");
 		ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, "quoted string expected");
	}
//    push_outfile_name(cpp[id],id);/*KS added*/
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_set(int what) {
/*
 * parse sequences like `set zmap = 50.0;' or `set zmap = 50, idp = 2.5;'
 * (int, float or string)
 */
	int yy, state = 0, i, hit = 0;
	typedef enum { NOLIMIT, GEZERO, GTZERO } Limit;
	typedef struct { char *name; void *p; int type; Limit limit; } Set_option;
	const Set_option set_options[] = {
	{ "cn$_max",        &gl_cn_max,       3, 2 }, //IS_REAL, GTZERO  },
	{ "co$incide",      &gl_coincide,     1, 1 }, //IS_INT,  GEZERO  },
	{ "Cr$essie",       &gl_cressie,      1, 1 }, //IS_INT,  GEZERO  },
	{ "a$lpha",         &gl_alpha,        3, 1 }, //IS_REAL, GEZERO  },
	{ "b$eta",          &gl_beta,         3, 1 }, //IS_REAL, GEZERO  },
	{ "c$utoff",        &gl_cutoff,       3, 2 }, //IS_REAL, GTZERO  },
	{ "de$bug",         &debug_level,     1, 1 }, //IS_INT,  GEZERO  },
	{ "display",        &gl_display,      4, 0 }, //IS_STRING, NOLIMIT },
	{ "do$ts",          &gl_dots,         1, 1 }, //IS_INT,  GEZERO  },
	{ "fit",            &gl_fit,          1, 1 }, //IS_INT,  GEZERO  },
	{ "fit_l$imit",     &gl_fit_limit,    3, 2 }, //IS_REAL, GTZERO  },
	{ "fo$rmat",        &gl_format,       4, 0 }, //IS_STRING, NOLIMIT },
	{ "fr$action",      &gl_fraction,     3, 2 }, //IS_REAL, GTZERO  },
	{ "gcv",            &gl_gcv,          3, 2 }, //IS_REAL, GTZERO  },
	{ "gls$_residuals", &gl_gls_residuals, 1, 1 }, //IS_INT, GEZERO  },
	{ "gnuplot",        &gl_gnuplot,      4, 0 }, //IS_STRING, NOLIMIT },
	{ "gnuplot35",      &gl_gnuplot35,    4, 0 }, //IS_STRING, NOLIMIT },
	{ "gpt$erm",        &gl_gpterm,       4, 0 }, //IS_STRING, NOLIMIT  },
	{ "id$p",           &gl_idp,          3, 2 }, //IS_REAL, GTZERO  },
	{ "in$tervals",     &gl_n_intervals,  1, 2 }, //IS_INT,  GTZERO  },
	{ "it$er",          &gl_iter,         1, 1 }, //IS_INT,  GEZERO  },
	{ "j$graph",        &gl_jgraph,       1, 1 }, //IS_INT,  GEZERO  },
	{ "lhs",            &gl_lhs,          1, 1 }, //IS_INT,  GEZERO  },
	{ "log$file",       &logfile_name,    4, 0 }, //IS_STRING, NOLIMIT },
	{ "mv$string",		&gl_mv_string,    4, 0 }, //IS_STRING, NOLIMIT },
	{ "n_uk",           &gl_n_uk,         1, 1 }, //IS_INT,  GEZERO  },
	{ "numbers",        &gl_numbers,      1, 1 }, //IS_INT,  GEZERO  },
	{ "nb$lockdiscr",   &gl_nblockdiscr,  1, 2 }, //IS_INT,  GTZERO  },
	{ "no$check",       &gl_nocheck,      1, 1 }, //IS_INT,  GEZERO  },
	{ "ns$im",          &gl_nsim,         1, 2 },
	{ "o$utputfile",    &o_filename,      4, 0 }, //IS_STRING, NOLIMIT },
	{ "or$der",         &gl_order,        1, 1 }, //IS_INT,  GEZERO },
	{ "pag$er",         &gl_pager,        4, 0 }, //IS_STRING, NOLIMIT },
	{ "pl$otfile",      &gl_gnufile,      4, 0 }, //IS_STRING, NOLIMIT },
	{ "q$uantile",      &gl_quantile,     3, 2 }, //IS_REAL, GTZERO  },
	{ "rp",             &gl_rp,           1, 1 }, //IS_INT,  GEZERO  },
	{ "sec$ure",        &gl_secure,       1, 2 }, //IS_INT,  GTZERO  },
	{ "see$d",          &gl_seed,         1, 2 }, //IS_INT,  GTZERO  },
	{ "useed",          &gl_seed,         2, 1 }, //IS_UINT,  GEZERO  },
	{ "spa$rse",        &gl_sparse,       1, 1 }, //IS_INT,  GEZERO  },
	{ "spi$ral",        &gl_spiral,       1, 1 }, //IS_INT,  GEZERO  },
	{ "spl$it",         &gl_split,        1, 2 }, //IS_INT,  GTZERO  },
	{ "sy$mmetric",     &gl_sym_ev,       1, 1 }, //IS_INT,  GEZERO  },
	{ "tol_h$or",       &gl_tol_hor,      3, 1 }, //IS_REAL, GEZERO  },
	{ "tol_v$er",       &gl_tol_ver,      3, 1 }, //IS_REAL, GEZERO  },
	{ "v$erbose",       &debug_level,     1, 1 }, //IS_INT,  GEZERO  },
	{ "w$idth",         &gl_iwidth,       3, 1 }, //IS_REAL, GEZERO  },
	{ "x$valid",        &gl_xvalid,       1, 1 }, //IS_INT,  GEZERO  },
	{ "zero_di$st",     &gl_zero_est,     1, 1 }, //IS_INT,  GEZERO  },
	{ "zero",           &gl_zero,         3, 1 }, //IS_REAL, GEZERO  },
	{ "zm$ap",          &gl_zmap,         3, 0 }, //IS_REAL, NOLIMIT },
	{ NULL, NULL, 0, 0 }
	};

    //char *err_text = NULL;
    //err_text = (char *) emalloc(48); /*KS added*/
	while ((yy = (what ? what : yylex2())) != LX_SEMICOLON) {
		switch (state) {
			case 0:
				if (yy == LX_COMMA || yy == LX_WS)
					break;
				if (yy != LX_IDENTIFIER) {
					strcpy(gerr_text,lex_error2());
                	strcat(gerr_text, "variable name or `;' expected");
 			    	ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "variable name or `;' expected");
				}
				for (i = 0, hit = -1; hit < 0 && set_options[i].name; i++)
					if (almost_equals(yytext2,set_options[i].name))
						hit = i;
				if (hit < 0) {
					strcpy(gerr_text,lex_error2());
					if (what == 0) {
                     	strcat(gerr_text, "unknown set keyword");
 			    		ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "unknown set keyword");
                        }
					else {
                    	strcat(gerr_text, "unknown keyword");
 			    		ErrMsg(ER_SYNTAX, gerr_text);
					//KS	ErrMsg(ER_SYNTAX, "unknown keyword");
                        }
				}
				if (almost_equals(yytext2,"nb$lockdiscr"))
					gl_gauss = 0; /* side effect */
				state = 1;
				break;
			case 1:
				if (!(yy == LX_WS || yy == LX_EQ || yy == LX_COLON)) {
					strcpy(gerr_text,lex_error2());
                	strcat(gerr_text, "` ', `=' or `:' expected");
 			    	ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "` ', `=' or `:' expected");
				}
				state = 2;
				break;
			case 2:
				if (yy == LX_WS)
					break;
				switch(set_options[hit].type) {
					case 1/*LX_INT*/:
						if (yy != 1/*LX_INT*/ || read_int(yytext2,
								(int *)(set_options[hit].p))) {
                        	strcpy(gerr_text,lex_error2());
                			strcat(gerr_text, yytext2);
 			    			ErrMsg(ER_RDINT, gerr_text);
						//KS	ErrMsg(ER_RDINT,  yytext2);
						}
						switch (set_options[hit].limit) {
							case GEZERO:
								if (((int)(*((int *)(set_options[hit].p))))
										< 0) {
                                	strcpy(gerr_text,lex_error2());
                					strcat(gerr_text, "value should be >= 0");
 			    					ErrMsg(ER_IMPOSVAL, gerr_text);
								//KS	ErrMsg(ER_IMPOSVAL, "value should be >= 0");
								}
								break;
							case GTZERO:
								if (((int)(*((int *)(set_options[hit].p))))
										<= 0) {
									strcpy(gerr_text,lex_error2());
                					strcat(gerr_text, "value should be >= 0");
 			    					ErrMsg(ER_IMPOSVAL, gerr_text);
								//KS	ErrMsg(ER_IMPOSVAL, "value should be > 0");
								}
								break;
							default:
								break;
						}
						break;
					case 3/*LX_REAL*/:
						if ((yy != 3/*LX_REAL*/ && yy != 1/*LX_INT*/) ||
								read_double(/**/yytext2,
								(double *)(set_options[hit].p))) {
							strcpy(gerr_text,lex_error2());
                            strcat(gerr_text,  yytext2);
 			    			ErrMsg(ER_RDFLT, gerr_text);
						//KS	ErrMsg(ER_RDFLT,  yytext2);
						}
						switch (set_options[hit].limit) {
							case GEZERO:
								if (((double)(*((double *)(set_options[hit].p))))
										< 0.0) {
                                	strcpy(gerr_text,lex_error2());
                            		strcat(gerr_text, "value should be >= 0.0");
 			    					ErrMsg(ER_IMPOSVAL, gerr_text);
								//KS	ErrMsg(ER_IMPOSVAL,"value should be >= 0.0");
								}
								break;
							case GTZERO:
								if (((double)(*((double *)(set_options[hit].p))))
										<= 0.0) {
									strcpy(gerr_text,lex_error2());
                            		strcat(gerr_text, "value should be >= 0.0");
 			    					ErrMsg(ER_IMPOSVAL, gerr_text);
								//KS	ErrMsg(ER_IMPOSVAL,"value should be > 0.0");
								}
								break;
							default:
								break;
						}
						break;
					case 4/*LX_STRING*/:
						if (yy != 4/*LX_STRING*/) {
							strcpy(gerr_text,lex_error2());
                            strcat(gerr_text, "quoted string expected");
 			    			ErrMsg(ER_SYNTAX, gerr_text);
						//KS	ErrMsg(ER_SYNTAX, "quoted string expected");
						}
						*((char **)(set_options[hit].p)) =
							unquote_dup(yytext2);
						break;
					default:
                    ErrMsg(ER_IMPOSVAL, "problem in parse_set()");
					//KS	ErrMsg(ER_IMPOSVAL, "panic! in parse_set()");
				}
				state = 0;
				break;
			default:
				strcpy(gerr_text,lex_error2());
                strcat(gerr_text, "impossible state");
 	   			ErrMsg(ER_IMPOSVAL, gerr_text);
			//KS	ErrMsg(ER_IMPOSVAL, "impossible state");
				break;
		} /* switch state */
		what = 0;
	} /* while */
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_mask(void) {
/*
 * parse one or more mask names
 */
	int yy, state = 0, done = 0;
	char *mname = NULL;
    //char *err_text = NULL; /*KS added*/
    int c, i;/*KS added*/
    bool readname; /*KS added*/
    //err_text = (char *) emalloc(44); /*KS added*/

	while ((yy = yylex2()) != LX_SEMICOLON) {
		switch (yy) {
			case LX_WS:
                /*KS added section to deal with spaces in filenames*/
                    if (!mname && (strlen(yytext2) > 0)) {
                        mname = (char *) emalloc(strlen(yytext2));
                        strcat(mname,yytext2);
                        } else if (mname) {
                            mname = (char *) erealloc(mname,strlen(mname)+2);
                            //strcat(mname,yytext2);
                            strcat(mname," ");
                            }
				break;
			case LX_COMMA:
				if (state != 1) {
					strcpy(gerr_text,lex_error2());
                	strcat(gerr_text, "quoted string expected");
 	   				ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "quoted string expected");
				}
                push_mask_name(mname);
                mname = NULL;
				state = 0;
				break;
            case LX_IDENTIFIER:  /*KS added*/
            case 1/*LX_INT*/:         /*KS added*/
			case 4/*LX_STRING*/:
				//done = 1;
                c = *yy_Source;
    				if (c == 45) {                 /*KS added section to accept "-" dash in filenames*/
                    	i = strlen(yytext2);
                        //yytext2[i-1] = *yy_Source;
                        yy_Source++;
                        c = *yy_Source;
                        while (isalnum(c) && (*yy_Source != EOF) || (c == 95) || (c == 46) || (c == 45)) {
            				yytext2[i] = *yy_Source;
            				yy_Source++;
            				c = *yy_Source;
            				i++;
            			}
                       // yytext2[i] = yytext2[i-1]; {8/31/99}
                     }
				if (mname) {
                    	mname = (char *) erealloc(mname,strlen(mname)+strlen(yytext2));
                    	strcat(mname,yytext2);
                        } else mname = unquote_dup(yytext2);
//				push_mask_name(name);
//				efree(name);
				state = 1;
				break;
			default:
            	strcpy(gerr_text,lex_error2());

				if (state == 1) {
                    strcat(gerr_text, " `,' expected");
 	   				ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, " `,' expected");
                	}
				else {
                    strcat(gerr_text, "quoted string expected");
 	   				ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "quoted string expected");
                    }
				break;
		}
	}
    if (mname) done = 1;
	if (! done) {
		strcpy(gerr_text,lex_error2());
       	strcat(gerr_text, "quoted string expected");
 		ErrMsg(ER_SYNTAX, gerr_text);
	//KS	ErrMsg(ER_SYNTAX, "quoted string expected");
	}
    push_mask_name(mname);
    efree(mname);
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_bounds(int when) {
/* accept either `bounds: 10, 15 25, 30,40;' or `bounds: "boundary.file"; ' */

	int yy, state = 0, i = 0, length = 0;
	float value;
    //char *err_text = NULL; /*KS added*/

    //err_text = (char *) emalloc(76); /*KS added*/

	while ((yy = yylex2()) != LX_SEMICOLON && (yy != 0)) {
		switch (yy) {
			case LX_WS:
			case LX_COMMA:
				break;
			case 3/*LX_REAL*/:
			case 1/*LX_INT*/:
				if (state == 2) {
					strcpy(gerr_text,lex_error2());
       				strcat(gerr_text, "use either file name or values");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "use either file name or values");
				}
				if (read_float( yytext2, &value)) {
					strcpy(gerr_text,lex_error2());
       				strcat(gerr_text,  yytext2);
 					ErrMsg(ER_RDFLT, gerr_text);
				//KS	ErrMsg(ER_RDFLT,  yytext2);
				}
				if (!gl_bounds) {
					length = 16;
					gl_bounds = (double *) emalloc(length * sizeof(double));
				}
				if (i == length - 2) {
					length += 16;
					gl_bounds = (double *) erealloc(gl_bounds, length * sizeof(double));
				}
				gl_bounds[i] = value;
				if (i > 0 && gl_bounds[i] <= gl_bounds[i-1]) {
                    strcpy(gerr_text,lex_error2());
       				strcat(gerr_text, "bounds must be strictly increasing");
 					ErrMsg(ER_IMPOSVAL, gerr_text);
				//KS	ErrMsg(ER_IMPOSVAL, "bounds must be strictly increasing");
				}
				i++;
				state = 1;
				break;
			case 4/*LX_STRING*/:
				if (when == 1) {
                    strcpy(gerr_text,lex_error2());
       				strcat(gerr_text, "only values allowed in boundary file");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "only values allowed in boundary file");
				}
				if (state == 1) {
					strcpy(gerr_text,lex_error2());
       				strcat(gerr_text,  "use either file name or values");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "use either file name or values");
				}
				boundary_file = unquote_dup(yytext2);
				state = 2;
				break;
			default:
				strcpy(gerr_text,lex_error2());

				if (state == 0) {
                    strcat(gerr_text,  "file name or list of numbers expected");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "file name or list of numbers expected");
                	}
				if (state == 1) {
                    strcat(gerr_text,  "number expected");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "number expected");
                	}
				if (state == 2) {
                    strcat(gerr_text, "`;' expected");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "`;' expected");
                    }
				break;
		}
	}
	if (state == 1)
		gl_bounds[i] = -1.0;
    //efree(err_text); /*KS added*/
	return yy;
}

static int parse_marginals(void) {
	int yy, state = 0;
	float value;
    //char *err_text = NULL; /*KS added*/

    //err_text = (char *) emalloc(74); /*KS added*/
	while ((yy = yylex2()) != LX_SEMICOLON && (yy != 0)) {
		switch (yy) {
			case LX_WS:
			case LX_COMMA:
				break;
			case 3/*LX_REAL*/:
			case 1/*LX_INT*/:
				if (state == 0)
					state = 1;
				if (state == 2 || gl_marginal_names) {
                	strcpy(gerr_text,lex_error2());
       				strcat(gerr_text,  "only real values allowed");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "only real values allowed");
				}
				gl_marginal_values = (double *) erealloc (gl_marginal_values,
					++gl_n_marginals * sizeof(double));
				if (read_float( yytext2, &value)) {
					strcpy(gerr_text,lex_error2());
       				strcat(gerr_text,  yytext2);
 					ErrMsg(ER_RDFLT, gerr_text);
				//KS	ErrMsg(ER_RDFLT,  yytext2);
				}
				gl_marginal_values[gl_n_marginals - 1] = value;
				break;
			case 4/*LX_STRING*/:
				if (state == 0)
					state = 2;
				if (state == 1 || gl_marginal_values) {
					strcpy(gerr_text,lex_error2());
       				strcat(gerr_text, "only quoted strings allowed");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "only quoted strings allowed");
				}
				gl_marginal_names = (char **) erealloc(gl_marginal_names,
					++gl_n_marginals * sizeof(char));
				gl_marginal_names[gl_n_marginals - 1] =
					unquote_dup(yytext2);
				break;
			default:
				strcpy(gerr_text,lex_error2());

				if (state == 0) {
                   	strcat(gerr_text, "file names or list of numbers expected");
 					ErrMsg(ER_SYNTAX, gerr_text);
				//KS	ErrMsg(ER_SYNTAX, "file names or list of numbers expected");
                }
                strcat(gerr_text, "unexpeced token");
                ErrMsg(ER_SYNTAX, gerr_text);
		   //KS		ErrMsg(ER_SYNTAX, "unexpeced token");
		}
	}
    //efree(err_text); /*KS added*/
	return yy;
}

static char *unquote_dup(const char *txt) {
/*
 * return malloc'd duplicate of txt, without first and last character (")
 */
	int len;
	char *cp = NULL;

	len = strlen(txt);
	/* copy: */
//KS	cp = (char *) emalloc ((len-1) * sizeof (char)); changed len-1 to len
    cp = (char *) emalloc ((len * sizeof (char))+1);
//KS	strncpy(cp,  &(txt[1]), len - 2); changed txt[1] to txt[0], len-2 to len
    strncpy(cp, /*(const char *)*/ &(txt[0]), len);
//KS	cp[len-2] = '\0'; /* make sure... */
    if (ispunct(cp[len-1])!=0) cp[len-1] = '\0'; /* make sure... */
	return cp;
}
