
/*  A Bison parser, made from parse.y
 by  GNU Bison version 1.27
  */

#define YYBISON 1  /* Identify Bison output.  */

#define	INT	257
#define	UINT	258
#define	REAL	259
#define	QSTR	260
#define	IDENT	261
#define	ID_DATA	262
#define	ID_X	263
#define	ID_VARIOGRAM	264
#define	ID_PREDICTIONS	265
#define	ID_VARIANCES	266
#define	ID_COVARIANCES	267
#define	ID_OUTPUT	268
#define	ID_MASKS	269
#define	ID_EDGES	270
#define	ID_SET	271
#define	ID_MERGE	272
#define	ID_AREA	273
#define	ID_BLOCK	274
#define	ID_METHOD	275
#define	ID_BOUNDS	276
#define	ID_MARGINALS	277

#line 1 "parse.y"

/*
    Gstat, a program for geostatistical modelling, prediction and simulation
    Copyright 1992, 1999 (C) Edzer J. Pebesma

    Edzer J. Pebesma, e.pebesma@geog.uu.nl
    Department of physical geography, Utrecht University
    P.O. Box 80.115, 3508 TC Utrecht, The Netherlands

    This program is free software; you can redistribute it and/or modify
    it under the terms of the GNU General Public License as published by
    the Free Software Foundation; either version 2 of the License, or
    (at your option) any later version.

    This program is distributed in the hope that it will be useful,
    but WITHOUT ANY WARRANTY; without even the implied warranty of
    MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
    GNU General Public License for more details.

    You should have received a copy of the GNU General Public License
    along with this program; if not, write to the Free Software
    Foundation, Inc., 675 Mass Ave, Cambridge, MA 02139, USA.

    (read also the files COPYING and Copyright)
*/

/*
 * parse.y: LALR(1) grammar for the gstat command syntax.
 * to make parse.c, type ``make parse.c'', it will use bison or yacc.
 *
 * If you fail (or don't have bison or yacc), then copy the file parse.c_
 * to parse.c. All this can be prevented by running configure while NO_YACC
 * is defined.
 * 
 * The parser assumes that in the function yylex() each identifier is
 * duplicated to ylval.sval, not just a pointer-copy. (some memory loss
 * will occur as a result)
 *
 * hints to extend the parser: 
 * o add a command: copy all from the most similar available command
 *   (add a %token and %type declaration, add a rule, add a return value
 *   from yylex() -> see the IDENT actions in lex.l)
 * o add a ``set'' variable: modify is_set_expr(), glvars.[ch] and defaults.h
 * o add a data() command: modify data.[ch] and is_data_expr()
 * o add a variogram model: vario*.[ch]
 */
#include <stdio.h>
#include <stdlib.h>
#include <string.h>
#include <math.h>
#include <io.h>

#include "defs.h"




#include "data.h"
#include "vario.h"
#include "debug.h"
#include "glvars.h"
#include "userio.h"
#include "utils.h"
#include "lex.h"

static DATA *d = NULL, **dpp = NULL;
static DPOINT *bp = NULL;
static VARIOGRAM *v = NULL;
static int id = -1, id1 = -1, id2 = -1, col1 = -1, col2 = -1,
	fit_sill = 0, fit_range = 0, vector_only = 0, allow_vector_only = 0;
static double range = -1.0, anis[5];
static char **ofn = NULL, *boundary_file = NULL;
static VARIOGRAM *parse_variogram = NULL;
static D_VECTOR *sd_vector = NULL;

#ifdef YYBISON
# ifndef __STDC__
#  define __STDC__
/* or else all const's will be defined empty */
# endif
#endif

typedef struct {
	const char *name;
	void *ptr;
	enum { 
		UNKNOWN, 
		IS_INT, 
		IS_UINT, 
		IS_REAL, 
		IS_STRING, 
		IS_D_VECTOR, 
		NO_ARG 
	} what;
	enum { 
		NOLIMIT, 
		GEZERO, 
		GTZERO 
	} limit;
} GSTAT_EXPR;

GSTAT_EXPR expr = { NULL, NULL, 0/*UNKNOWN*/, 0/*NOLIMIT*/ };

static void push_to_v(const char *mod, double sill, double range, double *d,
		int fit_sill, int fit_range);
static void push_data_X(DATA *d, int id);
static ANIS_TM *get_tm(double anis[5]);
static int is_data_expr(DATA *d, GSTAT_EXPR *expr, const char *fld);
static int is_set_expr(GSTAT_EXPR *expr, const char *fld);
static int is_block_expr(GSTAT_EXPR *expr, const char *s);
static void push_marginal(char *name, double val);
static void check_assign_expr(GSTAT_EXPR *expr);
static void reset_parser(void);
static void verify_data(DATA *d);

#define yyerror(s) lex_error()


#line 120 "parse.y"
typedef union {
	int ival;
	unsigned int uval;
	double dval;
	char *sval;
} YYSTYPE;
#include <stdio.h>

#ifndef __cplusplus
#ifndef __STDC__
#define const
#endif
#endif



#define	YYFINAL		242
#define	YYFLAG		-32768
#define	YYNTBASE	36

#define YYTRANSLATE(x) ((unsigned)(x) <= 277 ? yytranslate[x] : 80)

static const char yytranslate[] = {     0,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    32,     2,    30,
    31,     2,    33,    27,    34,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,    26,    24,     2,
    25,     2,     2,    35,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
    28,     2,    29,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     1,     3,     4,     5,     6,
     7,     8,     9,    10,    11,    12,    13,    14,    15,    16,
    17,    18,    19,    20,    21,    22,    23
};

#if YYDEBUG != 0
static const short yyprhs[] = {     0,
     0,     1,     4,     6,     8,    11,    14,    17,    20,    23,
    26,    29,    32,    35,    38,    41,    44,    46,    48,    50,
    52,    54,    56,    60,    62,    66,    69,    71,    73,    75,
    77,    79,    81,    83,    85,    87,    89,    91,    93,    95,
    97,    99,   101,   103,   107,   109,   114,   118,   122,   124,
   128,   129,   133,   135,   139,   143,   147,   151,   153,   155,
   159,   161,   163,   165,   167,   171,   173,   177,   181,   183,
   187,   189,   193,   199,   207,   211,   217,   221,   226,   230,
   235,   242,   244,   247,   252,   258,   265,   272,   274,   276,
   282,   294,   296,   299,   302,   304,   307,   311,   318,   322,
   329,   333,   342,   345,   347,   351,   355,   359,   363,   365,
   369,   373,   375,   379,   383,   385,   389,   394,   405,   409,
   413,   415,   418,   422,   426,   428,   432,   434
};

static const short yyrhs[] = {    -1,
    36,    37,     0,    42,     0,    24,     0,    45,    24,     0,
    58,    24,     0,    75,    24,     0,    71,    24,     0,    73,
    24,     0,    52,    24,     0,    56,    24,     0,    66,    24,
     0,    70,    24,     0,    76,    24,     0,    78,    24,     0,
    67,    24,     0,     3,     0,     5,     0,    25,     0,    26,
     0,    26,     0,    27,     0,    28,    42,    29,     0,    43,
     0,    42,    27,    43,     0,    42,    43,     0,    38,     0,
     7,     0,    19,     0,    20,     0,    22,     0,    13,     0,
     8,     0,    23,     0,    15,     0,    21,     0,    14,     0,
    11,     0,    17,     0,    12,     0,    10,     0,     9,     0,
    16,     0,    46,    26,    47,     0,    46,     0,     8,    30,
    44,    31,     0,     8,    30,    31,     0,     8,    30,     1,
     0,    48,     0,    47,    27,    48,     0,     0,     9,    25,
    49,     0,     6,     0,    51,    25,     3,     0,    51,    25,
     5,     0,    51,    25,     6,     0,    51,    25,    41,     0,
    51,     0,    50,     0,    49,    32,    50,     0,     7,     0,
     3,     0,     7,     0,    20,     0,    20,    26,    53,     0,
    54,     0,    53,    27,    54,     0,    55,    25,    38,     0,
     7,     0,    57,    26,    47,     0,    19,     0,    19,    30,
    31,     0,    59,    26,     6,    40,    60,     0,    59,    26,
     6,    40,     6,    40,    60,     0,    59,    26,     6,     0,
    59,    26,     6,    40,     6,     0,    59,    26,    60,     0,
    59,    26,     1,    24,     0,    10,    30,    31,     0,    10,
    30,    44,    31,     0,    10,    30,    44,    27,    44,    31,
     0,    61,     0,    60,    61,     0,    64,    62,    30,    31,
     0,    64,    62,    30,    63,    31,     0,    33,    64,    62,
    30,    63,    31,     0,    34,    64,    62,    30,    63,    31,
     0,     7,     0,    65,     0,    65,    27,    38,    27,    38,
     0,    65,    27,    38,    27,    38,    27,    38,    27,    38,
    27,    38,     0,    38,     0,    35,    38,     0,    38,    35,
     0,    38,     0,    35,    38,     0,    14,    25,     6,     0,
    11,    30,    44,    31,    26,     6,     0,    11,    26,     6,
     0,    12,    30,    44,    31,    26,     6,     0,    12,    26,
     6,     0,    13,    30,    44,    27,    44,    31,    26,     6,
     0,    17,    68,     0,    68,     0,    69,    39,     3,     0,
    69,    39,     4,     0,    69,    39,     5,     0,    69,    39,
     6,     0,     7,     0,    21,    26,     7,     0,    15,    26,
    72,     0,     6,     0,    72,    27,     6,     0,    16,    26,
    74,     0,     6,     0,    74,    27,     6,     0,    18,    44,
     7,    44,     0,    18,    44,    30,     3,    31,     7,    44,
    30,     3,    31,     0,    22,    26,     6,     0,    22,    26,
    77,     0,    38,     0,    77,    38,     0,    77,    27,    38,
     0,    23,    26,    79,     0,    38,     0,    79,    27,    38,
     0,     6,     0,    79,    27,     6,     0
};

#endif

#if YYDEBUG != 0
static const short yyrline[] = { 0,
   144,   145,   146,   149,   150,   151,   152,   153,   154,   155,
   156,   157,   158,   159,   160,   161,   164,   165,   167,   168,
   171,   172,   175,   177,   178,   179,   181,   188,   188,   188,
   188,   188,   188,   189,   189,   189,   189,   189,   190,   190,
   190,   190,   190,   194,   195,   198,   204,   208,   211,   212,
   215,   216,   217,   218,   226,   234,   241,   252,   260,   261,
   264,   278,   281,   289,   293,   296,   297,   300,   306,   309,
   312,   317,   324,   325,   326,   327,   328,   329,   335,   341,
   347,   359,   360,   363,   366,   369,   372,   377,   383,   384,
   391,   401,   402,   403,   405,   406,   408,   409,   414,   422,
   427,   435,   447,   448,   451,   459,   466,   473,   482,   485,
   499,   502,   503,   506,   509,   510,   513,   528,   547,   548,
   551,   552,   553,   556,   558,   559,   560,   561
};
#endif


#if YYDEBUG != 0 || defined (YYERROR_VERBOSE)

static const char * const yytname[] = {   "$","error","$undefined.","INT","UINT",
"REAL","QSTR","IDENT","ID_DATA","ID_X","ID_VARIOGRAM","ID_PREDICTIONS","ID_VARIANCES",
"ID_COVARIANCES","ID_OUTPUT","ID_MASKS","ID_EDGES","ID_SET","ID_MERGE","ID_AREA",
"ID_BLOCK","ID_METHOD","ID_BOUNDS","ID_MARGINALS","';'","'='","':'","','","'['",
"']'","'('","')'","'&'","'+'","'-'","'@'","input","command","val","assign","comcol",
"d_vector","d_list","d_val","any_id","data_cmd","data_decl","data_cont","data_exp",
"data_X","data_X_what","data_what","block_cmd","block_cont","block_exp","block_lhs",
"area_cmd","area_decl","vgm_cmd","vgm_decl","vgm_cont","vgm_model","vgm_model_type",
"vgm_range","sill_val","range_val","output_cmd","set_cmd","set_exp","set_lhs",
"method_cmd","mask_cmd","mask_cont","edges_cmd","edges_cont","merge_cmd","bounds_cmd",
"bounds_exp","marginals_cmd","marginals_cont", NULL
};
#endif

static const short yyr1[] = {     0,
    36,    36,    36,    37,    37,    37,    37,    37,    37,    37,
    37,    37,    37,    37,    37,    37,    38,    38,    39,    39,
    40,    40,    41,    42,    42,    42,    43,    44,    44,    44,
    44,    44,    44,    44,    44,    44,    44,    44,    44,    44,
    44,    44,    44,    45,    45,    46,    46,    46,    47,    47,
    48,    48,    48,    48,    48,    48,    48,    48,    49,    49,
    50,    50,    51,    52,    52,    53,    53,    54,    55,    56,
    57,    57,    58,    58,    58,    58,    58,    58,    59,    59,
    59,    60,    60,    61,    61,    61,    61,    62,    63,    63,
    63,    64,    64,    64,    65,    65,    66,    66,    66,    66,
    66,    66,    67,    67,    68,    68,    68,    68,    69,    70,
    71,    72,    72,    73,    74,    74,    75,    75,    76,    76,
    77,    77,    77,    78,    79,    79,    79,    79
};

static const short yyr2[] = {     0,
     0,     2,     1,     1,     2,     2,     2,     2,     2,     2,
     2,     2,     2,     2,     2,     2,     1,     1,     1,     1,
     1,     1,     3,     1,     3,     2,     1,     1,     1,     1,
     1,     1,     1,     1,     1,     1,     1,     1,     1,     1,
     1,     1,     1,     3,     1,     4,     3,     3,     1,     3,
     0,     3,     1,     3,     3,     3,     3,     1,     1,     3,
     1,     1,     1,     1,     3,     1,     3,     3,     1,     3,
     1,     3,     5,     7,     3,     5,     3,     4,     3,     4,
     6,     1,     2,     4,     5,     6,     6,     1,     1,     5,
    11,     1,     2,     2,     1,     2,     3,     6,     3,     6,
     3,     8,     2,     1,     3,     3,     3,     3,     1,     3,
     3,     1,     3,     3,     1,     3,     4,    10,     3,     3,
     1,     2,     3,     3,     1,     3,     1,     3
};

static const short yydefact[] = {     1,
    17,    18,     0,    27,     3,    24,   109,     0,     0,     0,
     0,     0,     0,     0,     0,     0,     0,    71,    64,     0,
     0,     0,     4,     2,     0,    45,     0,     0,     0,     0,
     0,     0,     0,   104,     0,     0,     0,     0,     0,     0,
     0,     0,    26,     0,     0,     0,     0,     0,     0,     0,
     0,     0,     0,   103,    28,    33,    42,    41,    38,    40,
    32,    37,    35,    43,    39,    29,    30,    36,    31,    34,
     0,     0,     0,     0,     0,     0,     5,    51,    10,    11,
    51,     6,     0,    12,    16,    19,    20,     0,    13,     8,
     9,     7,    14,    15,    25,    48,    47,     0,    79,     0,
    99,     0,   101,     0,     0,    97,   112,   111,   115,   114,
     0,     0,    72,    69,    65,    66,     0,   110,   119,   121,
   120,   127,   125,   124,    53,    63,     0,    44,    49,    58,
    70,     0,    75,     0,     0,     0,    92,    77,    82,     0,
   105,   106,   107,   108,    46,     0,    80,     0,     0,     0,
     0,     0,   117,     0,     0,     0,     0,   122,     0,     0,
    51,     0,    78,    21,    22,     0,     0,     0,    93,    94,
    83,    88,     0,     0,     0,     0,     0,   113,   116,     0,
    67,    68,   123,   128,   126,    62,    61,    52,    59,    50,
    54,    55,    56,     0,    57,    76,    73,     0,     0,     0,
    81,    98,   100,     0,     0,     0,     0,     0,     0,     0,
    84,     0,    95,     0,    89,     0,     0,    60,    23,    74,
     0,     0,    96,    85,     0,   102,     0,    86,    87,     0,
     0,     0,   118,    90,     0,     0,     0,     0,     0,    91,
     0,     0
};

static const short yydefgoto[] = {     3,
    24,   137,    88,   166,   195,     5,     6,    71,    25,    26,
   128,   129,   188,   189,   130,    27,   115,   116,   117,    28,
    29,    30,    31,   138,   139,   173,   214,   140,   215,    32,
    33,    34,    35,    36,    37,   108,    38,   110,    39,    40,
   121,    41,   124
};

static const short yypact[] = {    69,
-32768,-32768,   127,-32768,    14,-32768,-32768,    -9,    -1,   -12,
    38,     2,    53,     9,    59,    90,   207,    78,    98,   104,
   105,   106,-32768,-32768,    92,   107,   128,   129,   132,   130,
   134,   131,   137,-32768,    33,   138,   139,   152,   159,   160,
   161,    69,-32768,    79,   158,   176,   207,   180,   207,   207,
   181,   182,   184,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
    39,   162,   185,   188,   101,   112,-32768,   113,-32768,-32768,
   113,-32768,    10,-32768,-32768,-32768,-32768,   108,-32768,-32768,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   165,-32768,    40,
-32768,   166,-32768,   167,   164,-32768,-32768,   172,-32768,   174,
   207,   199,-32768,-32768,   177,-32768,   183,-32768,-32768,-32768,
    76,-32768,-32768,   178,-32768,-32768,   186,   179,-32768,   206,
   179,   189,    56,    25,    25,    69,   198,    21,-32768,   227,
-32768,-32768,-32768,-32768,-32768,   207,-32768,   210,   212,   207,
   234,   235,-32768,   211,   185,    69,    69,-32768,   120,    70,
   113,    34,-32768,-32768,-32768,    17,   227,   227,-32768,-32768,
-32768,-32768,   213,   214,   238,   240,   216,-32768,-32768,   241,
-32768,-32768,-32768,-32768,-32768,-32768,-32768,   217,-32768,-32768,
-32768,-32768,-32768,    69,-32768,    56,    21,   220,   221,    22,
-32768,-32768,-32768,   226,   207,    70,     7,    21,    28,    28,
-32768,    69,-32768,   222,   228,   248,   229,-32768,-32768,    21,
   225,   230,-32768,-32768,    69,-32768,   254,-32768,-32768,   231,
   232,    69,-32768,   233,    69,   237,    69,   239,    69,-32768,
   262,-32768
};

static const short yypgoto[] = {-32768,
-32768,     0,-32768,    71,-32768,    74,    -4,   -41,-32768,-32768,
   190,   109,-32768,    63,-32768,-32768,-32768,   110,-32768,-32768,
-32768,-32768,-32768,  -159,  -136,  -120,  -144,    -6,-32768,-32768,
-32768,   256,-32768,-32768,-32768,-32768,-32768,-32768,-32768,-32768,
-32768,-32768,-32768
};


#define	YYLAST		272


static const short yytable[] = {     4,
    43,   171,    98,   100,     4,   102,   197,   104,   105,     1,
   132,     2,     1,    46,     2,   133,     1,    47,     2,     1,
    44,     2,   196,     1,     1,     2,     2,     1,    45,     2,
     1,    50,     2,    42,    52,   219,   191,    95,   192,   193,
    42,     4,   134,   135,   136,   111,   198,   199,   220,   134,
   135,   136,   211,   134,   135,   136,   212,    86,    87,   136,
   171,   194,   212,    48,   221,   222,   146,    49,   112,   153,
   147,     1,   186,     2,   120,   123,   187,    51,     1,    96,
     2,   164,   165,   171,    53,    55,    56,    57,    58,    59,
    60,    61,    62,    63,    64,    65,     7,    66,    67,    68,
    69,    70,   157,     1,   174,     2,   119,    72,   177,    97,
   141,   142,   143,   144,     1,    77,     2,   122,   125,   126,
   158,   127,     1,    73,     2,   184,   241,   167,   168,    74,
    75,    76,    78,     7,     8,   169,     9,    10,    11,    12,
    13,    14,    15,    16,    17,    18,    19,    20,    21,    22,
    23,    79,    80,    82,    84,   182,   183,    81,   185,    83,
    85,    89,    90,   217,    55,    56,    57,    58,    59,    60,
    61,    62,    63,    64,    65,    91,    66,    67,    68,    69,
    70,   101,    92,    93,    94,   103,   106,   107,    99,   109,
   150,   114,   113,     4,   118,   145,   148,   149,   151,   213,
   152,   154,    43,   155,   159,   161,     4,   156,   213,   213,
   160,   223,   163,    55,    56,    57,    58,    59,    60,    61,
    62,    63,    64,    65,   230,    66,    67,    68,    69,    70,
   162,   234,   170,   172,   236,   175,   238,   176,   240,   178,
   179,   180,   200,   202,   201,   203,   204,   205,   206,   209,
   210,   216,   224,   226,   225,   228,   231,   232,   227,   235,
   229,   242,   233,   237,   181,   239,   208,   207,   218,   190,
   131,    54
};

static const short yycheck[] = {     0,
     5,   138,    44,    45,     5,    47,   166,    49,    50,     3,
     1,     5,     3,    26,     5,     6,     3,    30,     5,     3,
    30,     5,     6,     3,     3,     5,     5,     3,    30,     5,
     3,    30,     5,    27,    26,    29,     3,    42,     5,     6,
    27,    42,    33,    34,    35,     7,   167,   168,   208,    33,
    34,    35,    31,    33,    34,    35,    35,    25,    26,    35,
   197,    28,    35,    26,   209,   210,    27,    30,    30,   111,
    31,     3,     3,     5,    75,    76,     7,    25,     3,     1,
     5,    26,    27,   220,    26,     7,     8,     9,    10,    11,
    12,    13,    14,    15,    16,    17,     7,    19,    20,    21,
    22,    23,    27,     3,   146,     5,     6,    30,   150,    31,
     3,     4,     5,     6,     3,    24,     5,     6,     6,     7,
   121,     9,     3,    26,     5,     6,     0,   134,   135,    26,
    26,    26,    26,     7,     8,   136,    10,    11,    12,    13,
    14,    15,    16,    17,    18,    19,    20,    21,    22,    23,
    24,    24,    24,    24,    24,   156,   157,    26,   159,    26,
    24,    24,    24,   205,     7,     8,     9,    10,    11,    12,
    13,    14,    15,    16,    17,    24,    19,    20,    21,    22,
    23,     6,    24,    24,    24,     6,     6,     6,    31,     6,
    27,     7,    31,   194,     7,    31,    31,    31,    27,   200,
    27,     3,   207,    27,    27,    27,   207,    25,   209,   210,
    25,   212,    24,     7,     8,     9,    10,    11,    12,    13,
    14,    15,    16,    17,   225,    19,    20,    21,    22,    23,
    25,   232,    35,     7,   235,    26,   237,    26,   239,     6,
     6,    31,    30,     6,    31,     6,    31,     7,    32,    30,
    30,    26,    31,     6,    27,    31,     3,    27,    30,    27,
    31,     0,    31,    27,   155,    27,   196,   194,   206,   161,
    81,    16
};
/* -*-C-*-  Note some compilers choke on comments on `#line' lines.  */
#line 3 "/usr/lib/bison.simple"
/* This file comes from bison-1.27.  */

/* Skeleton output parser for bison,
   Copyright (C) 1984, 1989, 1990 Free Software Foundation, Inc.

   This program is free software; you can redistribute it and/or modify
   it under the terms of the GNU General Public License as published by
   the Free Software Foundation; either version 2, or (at your option)
   any later version.

   This program is distributed in the hope that it will be useful,
   but WITHOUT ANY WARRANTY; without even the implied warranty of
   MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
   GNU General Public License for more details.

   You should have received a copy of the GNU General Public License
   along with this program; if not, write to the Free Software
   Foundation, Inc., 59 Temple Place - Suite 330,
   Boston, MA 02111-1307, USA.  */

/* As a special exception, when this file is copied by Bison into a
   Bison output file, you may use that output file without restriction.
   This special exception was added by the Free Software Foundation
   in version 1.24 of Bison.  */

/* This is the parser code that is written into each bison parser
  when the %semantic_parser declaration is not specified in the grammar.
  It was written by Richard Stallman by simplifying the hairy parser
  used when %semantic_parser is specified.  */

#ifndef YYSTACK_USE_ALLOCA
#ifdef alloca
#define YYSTACK_USE_ALLOCA
#else /* alloca not defined */
#ifdef __GNUC__
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#else /* not GNU C.  */
#if (!defined (__STDC__) && defined (sparc)) || defined (__sparc__) || defined (__sparc) || defined (__sgi) || (defined (__sun) && defined (__i386))
#define YYSTACK_USE_ALLOCA
#include <alloca.h>
#else /* not sparc */
/* We think this test detects Watcom and Microsoft C.  */
/* This used to test MSDOS, but that is a bad idea
   since that symbol is in the user namespace.  */
#if (defined (_MSDOS) || defined (_MSDOS_)) && !defined (__TURBOC__)
#if 0 /* No need for malloc.h, which pollutes the namespace;
	 instead, just don't use alloca.  */
#include <malloc.h>
#endif
#else /* not MSDOS, or __TURBOC__ */
#if defined(_AIX)
/* I don't know what this was needed for, but it pollutes the namespace.
   So I turned it off.   rms, 2 May 1997.  */
/* #include <malloc.h>  */
 #pragma alloca
#define YYSTACK_USE_ALLOCA
#else /* not MSDOS, or __TURBOC__, or _AIX */
#if 0
#ifdef __hpux /* haible@ilog.fr says this works for HPUX 9.05 and up,
		 and on HPUX 10.  Eventually we can turn this on.  */
#define YYSTACK_USE_ALLOCA
#define alloca __builtin_alloca
#endif /* __hpux */
#endif
#endif /* not _AIX */
#endif /* not MSDOS, or __TURBOC__ */
#endif /* not sparc */
#endif /* not GNU C */
#endif /* alloca not defined */
#endif /* YYSTACK_USE_ALLOCA not defined */

#ifdef YYSTACK_USE_ALLOCA
#define YYSTACK_ALLOC alloca
#else
#define YYSTACK_ALLOC emalloc /*KS changed malloc to emalloc*/
#endif

/* Note: there must be only one dollar sign in this file.
   It is replaced by the list of actions, each action
   as one case of the switch.  */

#define yyerrok		(yyerrstatus = 0)
#define yyclearin	(yychar = YYEMPTY)
#define YYEMPTY		-2
#define YYEOF		0
#define YYACCEPT	goto yyacceptlab
#define YYABORT 	goto yyabortlab
#define YYERROR		goto yyerrlab1
/* Like YYERROR except do call yyerror.
   This remains here temporarily to ease the
   transition to the new meaning of YYERROR, for GCC.
   Once GCC version 2 has supplanted version 1, this can go.  */
#define YYFAIL		goto yyerrlab
#define YYRECOVERING()  (!!yyerrstatus)
#define YYBACKUP(token, value) \
do								\
  if (yychar == YYEMPTY && yylen == 1)				\
    { yychar = (token), yylval = (value);			\
      yychar1 = YYTRANSLATE (yychar);				\
      YYPOPSTACK;						\
      goto yybackup;						\
    }								\
  else								\
    { yyerror ("syntax error: cannot back up"); YYERROR; }	\
while (0)

#define YYTERROR	1
#define YYERRCODE	256

#ifndef YYPURE
#define YYLEX		yylex()
#endif

#ifdef YYPURE
#ifdef YYLSP_NEEDED
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, &yylloc, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval, &yylloc)
#endif
#else /* not YYLSP_NEEDED */
#ifdef YYLEX_PARAM
#define YYLEX		yylex(&yylval, YYLEX_PARAM)
#else
#define YYLEX		yylex(&yylval)
#endif
#endif /* not YYLSP_NEEDED */
#endif

/* If nonreentrant, generate the variables here */

#ifndef YYPURE

int	yychar;			/*  the lookahead symbol		*/
YYSTYPE	yylval;			/*  the semantic value of the		*/
				/*  lookahead symbol			*/

#ifdef YYLSP_NEEDED
YYLTYPE yylloc;			/*  location data for the lookahead	*/
				/*  symbol				*/
#endif

int yynerrs;			/*  number of parse errors so far       */
#endif  /* not YYPURE */

#if YYDEBUG != 0
int yydebug;			/*  nonzero means print parse trace	*/
/* Since this is uninitialized, it does not stop multiple parsers
   from coexisting.  */
#endif

/*  YYINITDEPTH indicates the initial size of the parser's stacks	*/

#ifndef	YYINITDEPTH
#define YYINITDEPTH 200
#endif

/*  YYMAXDEPTH is the maximum size the stacks can grow to
    (effective only if the built-in stack extension method is used).  */

#if YYMAXDEPTH == 0
#undef YYMAXDEPTH
#endif

#ifndef YYMAXDEPTH
#define YYMAXDEPTH 10000
#endif

/* Define __yy_memcpy.  Note that the size argument
   should be passed with type unsigned int, because that is what the non-GCC
   definitions require.  With GCC, __builtin_memcpy takes an arg
   of type size_t, but it can handle unsigned int.  */

#if __GNUC__ > 1		/* GNU C and GNU C++ define this.  */
#define __yy_memcpy(TO,FROM,COUNT)	__builtin_memcpy(TO,FROM,COUNT)
#else				/* not GNU C or C++ */
#ifndef __cplusplus

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (to, from, count)
     char *to;
     char *from;
     unsigned int count;
{
  register char *f = from;
  register char *t = to;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#else /* __cplusplus */

/* This is the most reliable way to avoid incompatibilities
   in available built-in functions on various systems.  */
static void
__yy_memcpy (char *to, char *from, unsigned int count)
{
  register char *t = to;
  register char *f = from;
  register int i = count;

  while (i-- > 0)
    *t++ = *f++;
}

#endif
#endif

#line 216 "/usr/lib/bison.simple"

/* The user can define YYPARSE_PARAM as the name of an argument to be passed
   into yyparse.  The argument should have type void *.
   It should actually point to an object.
   Grammar actions can access the variable by casting it
   to the proper pointer type.  */

#ifdef YYPARSE_PARAM
#ifdef __cplusplus
#define YYPARSE_PARAM_ARG void *YYPARSE_PARAM
#define YYPARSE_PARAM_DECL
#else /* not __cplusplus */
#define YYPARSE_PARAM_ARG YYPARSE_PARAM
#define YYPARSE_PARAM_DECL void *YYPARSE_PARAM;
#endif /* not __cplusplus */
#else /* not YYPARSE_PARAM */
#define YYPARSE_PARAM_ARG
#define YYPARSE_PARAM_DECL
#endif /* not YYPARSE_PARAM */

/* Prevent warning if -Wstrict-prototypes.  */
#ifdef __GNUC__
#ifdef YYPARSE_PARAM
int yyparse (void *);
#else
int yyparse (void);
#endif
#endif

int
yyparse(YYPARSE_PARAM_ARG)
     YYPARSE_PARAM_DECL
{
  register int yystate;
  register int yyn;
  register short *yyssp;
  register YYSTYPE *yyvsp;
  int yyerrstatus;	/*  number of tokens to shift before error messages enabled */
  int yychar1 = 0;		/*  lookahead token as an internal (translated) token number */

  short	yyssa[YYINITDEPTH];	/*  the state stack			*/
  YYSTYPE yyvsa[YYINITDEPTH];	/*  the semantic value stack		*/

  short *yyss = yyssa;		/*  refer to the stacks thru separate pointers */
  YYSTYPE *yyvs = yyvsa;	/*  to allow yyoverflow to reallocate them elsewhere */

#ifdef YYLSP_NEEDED
  YYLTYPE yylsa[YYINITDEPTH];	/*  the location stack			*/
  YYLTYPE *yyls = yylsa;
  YYLTYPE *yylsp;

#define YYPOPSTACK   (yyvsp--, yyssp--, yylsp--)
#else
#define YYPOPSTACK   (yyvsp--, yyssp--)
#endif

  int yystacksize = YYINITDEPTH;
  int yyfree_stacks = 0;

#ifdef YYPURE
  int yychar;
  YYSTYPE yylval;
  int yynerrs;
#ifdef YYLSP_NEEDED
  YYLTYPE yylloc;
#endif
#endif

  YYSTYPE yyval;		/*  the variable used to return		*/
				/*  semantic values from the action	*/
				/*  routines				*/

  int yylen;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Starting parse\n");
#endif

  yystate = 0;
  yyerrstatus = 0;
  yynerrs = 0;
  yychar = YYEMPTY;		/* Cause a token to be read.  */

  /* Initialize stack pointers.
     Waste one element of value and location stack
     so that they stay on the same level as the state stack.
     The wasted elements are never initialized.  */

  yyssp = yyss - 1;
  yyvsp = yyvs;
#ifdef YYLSP_NEEDED
  yylsp = yyls;
#endif

/* Push a new state, which is found in  yystate  .  */
/* In all cases, when you get here, the value and location stacks
   have just been pushed. so pushing a state here evens the stacks.  */
yynewstate:

  *++yyssp = yystate;

  if (yyssp >= yyss + yystacksize - 1)
    {
      /* Give user a chance to reallocate the stack */
      /* Use copies of these so that the &'s don't force the real ones into memory. */
      YYSTYPE *yyvs1 = yyvs;
      short *yyss1 = yyss;
#ifdef YYLSP_NEEDED
      YYLTYPE *yyls1 = yyls;
#endif

      /* Get the current used size of the three stacks, in elements.  */
      int size = yyssp - yyss + 1;

#ifdef yyoverflow
      /* Each stack pointer address is followed by the size of
	 the data in use in that stack, in bytes.  */
#ifdef YYLSP_NEEDED
      /* This used to be a conditional around just the two extra args,
	 but that might be undefined if yyoverflow is a macro.  */
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yyls1, size * sizeof (*yylsp),
		 &yystacksize);
#else
      yyoverflow("parser stack overflow",
		 &yyss1, size * sizeof (*yyssp),
		 &yyvs1, size * sizeof (*yyvsp),
		 &yystacksize);
#endif

      yyss = yyss1; yyvs = yyvs1;
#ifdef YYLSP_NEEDED
      yyls = yyls1;
#endif
#else /* no yyoverflow */
      /* Extend the stack our own way.  */
      if (yystacksize >= YYMAXDEPTH)
	{
	  yyerror("parser stack overflow");
	  if (yyfree_stacks)
	    {
	      efree (yyss);     /*KS changed from free to efree*/
	      efree (yyvs);
#ifdef YYLSP_NEEDED
	      efree (yyls);
#endif
	    }
	  return 2;
	}
      yystacksize *= 2;
      if (yystacksize > YYMAXDEPTH)
	yystacksize = YYMAXDEPTH;
#ifndef YYSTACK_USE_ALLOCA
      yyfree_stacks = 1;
#endif
      yyss = (short *) YYSTACK_ALLOC (yystacksize * sizeof (*yyssp));
      __yy_memcpy ((char *)yyss, (char *)yyss1,
		   size * (unsigned int) sizeof (*yyssp));
      yyvs = (YYSTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yyvsp));
      __yy_memcpy ((char *)yyvs, (char *)yyvs1,
		   size * (unsigned int) sizeof (*yyvsp));
#ifdef YYLSP_NEEDED
      yyls = (YYLTYPE *) YYSTACK_ALLOC (yystacksize * sizeof (*yylsp));
      __yy_memcpy ((char *)yyls, (char *)yyls1,
		   size * (unsigned int) sizeof (*yylsp));
#endif
#endif /* no yyoverflow */

      yyssp = yyss + size - 1;
      yyvsp = yyvs + size - 1;
#ifdef YYLSP_NEEDED
      yylsp = yyls + size - 1;
#endif

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Stack size increased to %d\n", yystacksize);
#endif

      if (yyssp >= yyss + yystacksize - 1)
	YYABORT;
    }

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Entering state %d\n", yystate);
#endif

  goto yybackup;
 yybackup:

/* Do appropriate processing given the current state.  */
/* Read a lookahead token if we need one and don't already have one.  */
/* yyresume: */

  /* First try to decide what to do without reference to lookahead token.  */

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yydefault;

  /* Not known => get a lookahead token if don't already have one.  */

  /* yychar is either YYEMPTY or YYEOF
     or a valid token in external form.  */

  if (yychar == YYEMPTY)
    {
#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Reading a token: ");
#endif
      yychar = YYLEX;
    }

  /* Convert token to internal form (in yychar1) for indexing tables with */

  if (yychar <= 0)		/* This means end of input. */
    {
      yychar1 = 0;
      yychar = YYEOF;		/* Don't call YYLEX any more */

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Now at end of input.\n");
#endif
    }
  else
    {
      yychar1 = YYTRANSLATE(yychar);

#if YYDEBUG != 0
      if (yydebug)
	{
	  fprintf (stderr, "Next token is %d (%s", yychar, yytname[yychar1]);
	  /* Give the individual parser a way to print the precise meaning
	     of a token, for further debugging info.  */
#ifdef YYPRINT
	  YYPRINT (stderr, yychar, yylval);
#endif
	  fprintf (stderr, ")\n");
	}
#endif
    }

  yyn += yychar1;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != yychar1)
    goto yydefault;

  yyn = yytable[yyn];

  /* yyn is what to do for this token type in this state.
     Negative => reduce, -yyn is rule number.
     Positive => shift, yyn is new state.
       New state is final state => don't bother to shift,
       just return success.
     0, or most negative number => error.  */

  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrlab;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrlab;

  if (yyn == YYFINAL)
    YYACCEPT;

  /* Shift the lookahead token.  */

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting token %d (%s), ", yychar, yytname[yychar1]);
#endif

  /* Discard the token being shifted unless it is eof.  */
  if (yychar != YYEOF)
    yychar = YYEMPTY;

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  /* count tokens shifted since error; after three, turn off error status.  */
  if (yyerrstatus) yyerrstatus--;

  yystate = yyn;
  goto yynewstate;

/* Do the default action for the current state.  */
yydefault:

  yyn = yydefact[yystate];
  if (yyn == 0)
    goto yyerrlab;

/* Do a reduction.  yyn is the number of a rule to reduce with.  */
yyreduce:
  yylen = yyr2[yyn];
  if (yylen > 0)
    yyval = yyvsp[1-yylen]; /* implement default value of the action */

#if YYDEBUG != 0
  if (yydebug)
    {
      int i;

      fprintf (stderr, "Reducing via rule %d (line %d), ",
	       yyn, yyrline[yyn]);

      /* Print the symbols being reduced, and their result.  */
      for (i = yyprhs[yyn]; yyrhs[i] > 0; i++)
	fprintf (stderr, "%s ", yytname[yyrhs[i]]);
      fprintf (stderr, " -> %s\n", yytname[yyr1[yyn]]);
    }
#endif


  switch (yyn) {

case 1:
#line 144 "parse.y"
{ ; ;
    break;}
case 2:
#line 145 "parse.y"
{ reset_parser(); ;
    break;}
case 3:
#line 146 "parse.y"
{ vector_only = 1; ;
    break;}
case 4:
#line 149 "parse.y"
{ ; ;
    break;}
case 5:
#line 150 "parse.y"
{ ; ;
    break;}
case 6:
#line 151 "parse.y"
{ update_variogram(v); ;
    break;}
case 7:
#line 152 "parse.y"
{ ; ;
    break;}
case 8:
#line 153 "parse.y"
{ ; ;
    break;}
case 9:
#line 154 "parse.y"
{ ; ;
    break;}
case 10:
#line 155 "parse.y"
{ ; ;
    break;}
case 11:
#line 156 "parse.y"
{ ; ;
    break;}
case 12:
#line 157 "parse.y"
{ ; ;
    break;}
case 13:
#line 158 "parse.y"
{ ; ;
    break;}
case 14:
#line 159 "parse.y"
{ ; ;
    break;}
case 15:
#line 160 "parse.y"
{ ; ;
    break;}
case 16:
#line 161 "parse.y"
{ ; ;
    break;}
case 17:
#line 164 "parse.y"
{ yyval.dval = (double) yyvsp[0].ival; ;
    break;}
case 19:
#line 167 "parse.y"
{ ; ;
    break;}
case 20:
#line 168 "parse.y"
{ ; ;
    break;}
case 21:
#line 171 "parse.y"
{ ; ;
    break;}
case 22:
#line 172 "parse.y"
{ ; ;
    break;}
case 23:
#line 175 "parse.y"
{ ; ;
    break;}
case 27:
#line 181 "parse.y"
{ 
			if (!d /*== NULL*/)
				sd_vector = push_to_vector(yyvsp[0].dval, sd_vector);
			else
				d->beta = push_to_vector(yyvsp[0].dval, d->beta);
		;
    break;}
case 43:
#line 191 "parse.y"
{ ; ;
    break;}
case 44:
#line 194 "parse.y"
{ verify_data(d); ;
    break;}
case 45:
#line 195 "parse.y"
{ d->dummy = 1; ;
    break;}
case 46:
#line 198 "parse.y"
{
			id = which_identifier(yyvsp[-1].sval);
			dpp = get_data();
			d = dpp[id];
			d->id = id;
		;
    break;}
case 47:
#line 204 "parse.y"
{
			d = get_dataval();
			d->id = ID_OF_VALDATA;
		;
    break;}
case 48:
#line 208 "parse.y"
{ ErrMsg(ER_SYNTAX, "invalid identifier"); ;
    break;}
case 51:
#line 215 "parse.y"
{ ; ;
    break;}
case 53:
#line 217 "parse.y"
{ d->fname = yyvsp[0].sval; ;
    break;}
case 54:
#line 218 "parse.y"
{
			switch (expr.what) {
				case 1/*IS_INT*/: *((int *)expr.ptr) = yyvsp[0].ival; break;
				case 3/*IS_REAL*/: *((double *)expr.ptr) = (double) yyvsp[0].ival; break;
				default: lex_error(); YYERROR; break;
			}
			check_assign_expr(&expr);
		;
    break;}
case 55:
#line 226 "parse.y"
{
			if (expr.what != 3/*IS_REAL*/) {
				lex_error();
				YYERROR;
			}
			*((double *)expr.ptr) = yyvsp[0].dval;
			check_assign_expr(&expr);
		;
    break;}
case 56:
#line 234 "parse.y"
{
			if (expr.what != 4/*IS_STRING*/) {
				lex_error();
				YYERROR;
			}
			*((char **)expr.ptr) = yyvsp[0].sval;
		;
    break;}
case 57:
#line 241 "parse.y"
{
			if (expr.what != 5/*IS_D_VECTOR*/) {
				lex_error();
				YYERROR;
			}
			/*
			*((D_VECTOR **)expr.ptr) = sd_vector;
			printf("[[ %d ]]\n", sd_vector->size);
			sd_vector = NULL;
			*/
		;
    break;}
case 58:
#line 252 "parse.y"
{
			if (expr.what != 6/*NO_ARG*/) {
				lex_error();
				YYERROR;
			}
		;
    break;}
case 61:
#line 264 "parse.y"
{
			for (id = 0; id < N_POLY; id++) {
				if (almost_equals(yyvsp[0].sval, polynomial[id].name)) {
					id += POLY_MIN;
					break; /* i-loop */
				}
			}
			if (id < 0)
				data_add_X(d, id);
			else {
				lex_error();
				YYERROR;
			}
		;
    break;}
case 62:
#line 278 "parse.y"
{ push_data_X(d, yyvsp[0].ival); ;
    break;}
case 63:
#line 281 "parse.y"
{
			if (! is_data_expr(d, &expr, yyvsp[0].sval)) {
				lex_error();
				YYERROR;
			}
		;
    break;}
case 64:
#line 289 "parse.y"
{
			bp = get_block_p();
			bp->x = -1.0; /* will be set to grid cell size in predict.c */
		;
    break;}
case 68:
#line 300 "parse.y"
{
			*((double *)expr.ptr) = yyvsp[0].dval;
			check_assign_expr(&expr);
		;
    break;}
case 69:
#line 306 "parse.y"
{ if (! is_block_expr(&expr, yyvsp[0].sval)) { lex_error(); YYERROR; };
    break;}
case 70:
#line 309 "parse.y"
{ ; ;
    break;}
case 71:
#line 312 "parse.y"
{
			create_data_area();
			d = get_data_area();
			d->id = ID_OF_AREA;
		;
    break;}
case 72:
#line 317 "parse.y"
{
			create_data_area();
			d = get_data_area();
			d->id = ID_OF_AREA;
		;
    break;}
case 73:
#line 324 "parse.y"
{ v->fname = yyvsp[-2].sval; ;
    break;}
case 74:
#line 325 "parse.y"
{ v->fname = yyvsp[-4].sval; v->fname2 = yyvsp[-2].sval; ;
    break;}
case 75:
#line 326 "parse.y"
{v->fname = yyvsp[0].sval; ;
    break;}
case 76:
#line 327 "parse.y"
{v->fname = yyvsp[-2].sval; v->fname2 = yyvsp[0].sval; ;
    break;}
case 78:
#line 329 "parse.y"
{ 
			/* this will eat the ';' as well, but we're bailing out anyway: */
			YYERROR; 
		;
    break;}
case 79:
#line 335 "parse.y"
{ 
			/* only allow this when called through read_variogram(): */
			assert(parse_variogram /*!= NULL*/);
			v = parse_variogram;
			v->n_models = v->n_fit = 0;
		;
    break;}
case 80:
#line 341 "parse.y"
{
			id = which_identifier(yyvsp[-1].sval);
			v = get_vgm(LTI(id,id));
			v->id = v->id1 = v->id2 = id;
			v->n_models = v->n_fit = 0;
		;
    break;}
case 81:
#line 347 "parse.y"
{
			id1 = which_identifier(yyvsp[-3].sval);
			id2 = which_identifier(yyvsp[-1].sval);
			id = LTI(id1,id2);
			v = get_vgm(id);
			v->id = id;
			v->id1 = id1;
			v->id2 = id2;
			v->n_models = v->n_fit = 0;
		;
    break;}
case 84:
#line 363 "parse.y"
{
			push_to_v(yyvsp[-2].sval, yyvsp[-3].dval, 0.0, NULL, fit_sill, fit_range);
		;
    break;}
case 85:
#line 366 "parse.y"
{
			push_to_v(yyvsp[-3].sval, yyvsp[-4].dval, range, anis, fit_sill, fit_range);
		;
    break;}
case 86:
#line 369 "parse.y"
{
			push_to_v(yyvsp[-3].sval, yyvsp[-4].dval, range, anis, fit_sill, fit_range);
		;
    break;}
case 87:
#line 372 "parse.y"
{
			push_to_v(yyvsp[-3].sval, -1.0 * yyvsp[-4].dval, range, anis, fit_sill, fit_range);
		;
    break;}
case 88:
#line 377 "parse.y"
{ 
			if (which_variogram_model(yyvsp[0].sval) == NOT_SP) {
				lex_error(); YYERROR;
			}
	;
    break;}
case 89:
#line 383 "parse.y"
{ range = yyvsp[0].dval; anis[0] = -9999.0; ;
    break;}
case 90:
#line 384 "parse.y"
{
			range = yyvsp[-4].dval;
			anis[0] = yyvsp[-2].dval;
			anis[3] = yyvsp[0].dval;
			anis[1] = anis[2] = 0.0;
			anis[4] = 1.0;
		;
    break;}
case 91:
#line 391 "parse.y"
{
			range = yyvsp[-10].dval;
			anis[0] = yyvsp[-8].dval;
			anis[1] = yyvsp[-6].dval;
			anis[2] = yyvsp[-4].dval;
			anis[3] = yyvsp[-2].dval;
			anis[4] = yyvsp[0].dval;
		;
    break;}
case 92:
#line 401 "parse.y"
{ fit_sill = 1; ;
    break;}
case 93:
#line 402 "parse.y"
{ fit_sill = 0; yyval.dval = yyvsp[0].dval; ;
    break;}
case 94:
#line 403 "parse.y"
{ fit_sill = 0; yyval.dval = yyvsp[-1].dval; ;
    break;}
case 95:
#line 405 "parse.y"
{ fit_range = 1; ;
    break;}
case 96:
#line 406 "parse.y"
{ fit_range = 0; yyval.dval = yyvsp[0].dval; ;
    break;}
case 97:
#line 408 "parse.y"
{ o_filename = yyvsp[0].sval; ;
    break;}
case 98:
#line 409 "parse.y"
{ 
			id = which_identifier(yyvsp[-3].sval);
			ofn = (char **) get_outfile_name();
			ofn[2 * id] = yyvsp[0].sval;
		;
    break;}
case 99:
#line 414 "parse.y"
{ 
			if (get_n_vars() == 0) {
				lex_error();
				ErrMsg(ER_SYNTAX, "define data first");
			}
			ofn = (char **) get_outfile_name();
			ofn[0] = yyvsp[0].sval;
		;
    break;}
case 100:
#line 422 "parse.y"
{ 
			id = which_identifier(yyvsp[-3].sval);
			ofn = (char **) get_outfile_name();
			ofn[2 * id + 1] = yyvsp[0].sval;
		;
    break;}
case 101:
#line 427 "parse.y"
{ 
			if (get_n_vars() == 0) {
				lex_error();
				ErrMsg(ER_SYNTAX, "define data first");
			}
			ofn = (char **) get_outfile_name();
			ofn[1] = yyvsp[0].sval;
		;
    break;}
case 102:
#line 435 "parse.y"
{ 
			id = get_n_vars();
			id1 = which_identifier(yyvsp[-5].sval);
			id2 = which_identifier(yyvsp[-3].sval);
			if (id != get_n_vars())	
				ErrMsg(ER_SYNTAX, "define all data(..) before covariances(..,..)");
			ofn = (char **) get_outfile_name();
			id = 2 * id + LTI2(id1, id2);
			ofn[id] = yyvsp[0].sval;
		;
    break;}
case 105:
#line 451 "parse.y"
{
			switch (expr.what) { 
				case 1/*IS_INT*/: *((int *)expr.ptr) = yyvsp[0].ival; break;
				case 3/*IS_REAL*/: *((double *)expr.ptr) = (double) yyvsp[0].ival; break;
				default: lex_error(); YYERROR;
			}
			check_assign_expr(&expr);
		;
    break;}
case 106:
#line 459 "parse.y"
{
			switch (expr.what) { 
				case 2/*IS_UINT*/: *((unsigned int *)expr.ptr) = yyvsp[0].uval; break;
				default: lex_error(); YYERROR;
			}
			check_assign_expr(&expr);
		;
    break;}
case 107:
#line 466 "parse.y"
{
			switch (expr.what) {
				case 3/*IS_REAL*/: *((double *)expr.ptr) = yyvsp[0].dval; break;
				default: lex_error(); YYERROR; break;
			}
			check_assign_expr(&expr);
		;
    break;}
case 108:
#line 473 "parse.y"
{
			if (expr.what != 4/*IS_STRING*/) {
				lex_error();
				YYERROR;
			}
			*((char **) expr.ptr) = yyvsp[0].sval;
		;
    break;}
case 109:
#line 482 "parse.y"
{ if (! is_set_expr(&expr, yyvsp[0].sval)) { lex_error(); YYERROR; };
    break;}
case 110:
#line 485 "parse.y"
{
			for (id = 1; NULL != methods[id].name; id++) {
				if (almost_equals(yyvsp[0].sval, methods[id].name)) {
					set_method(methods[id].m);
					break; /* id-loop */
				}
			}
			if (methods[id].m == NSP) {
				lex_error();
				YYERROR;
			}
		;
    break;}
case 112:
#line 502 "parse.y"
{ push_mask_name(yyvsp[0].sval); ;
    break;}
case 113:
#line 503 "parse.y"
{ push_mask_name(yyvsp[0].sval); ;
    break;}
case 115:
#line 509 "parse.y"
{ push_edges_name(yyvsp[0].sval); ;
    break;}
case 116:
#line 510 "parse.y"
{ push_edges_name(yyvsp[0].sval); ;
    break;}
case 117:
#line 513 "parse.y"
{
			if (!almost_equals(yyvsp[-1].sval, "w$ith"))
				lex_error();
			id1 = which_identifier(yyvsp[-2].sval);
			id2 = which_identifier(yyvsp[0].sval);
			col1 = col2 = 0;
			dpp = get_data();
			if (id1 < id2) { /* swap id's */
				id = id1; id1 = id2; id2 = id;
			}
			if (push_to_merge_table(dpp[id1], id2, col1, col2)) {
				lex_error();
				ErrMsg(ER_IMPOSVAL, "attempt to merge failed");
			}
		;
    break;}
case 118:
#line 528 "parse.y"
{
			if (!almost_equals(yyvsp[-4].sval, "w$ith"))
				lex_error();
			id1 = which_identifier(yyvsp[-8].sval);
			id2 = which_identifier(yyvsp[-3].sval);
			col1 = yyvsp[-6].ival;
			col2 = yyvsp[-1].ival;
			dpp = get_data();
			if (id1 < id2) { /* swap id and col */
				id = id1; id1 = id2; id2 = id;
				id = col1; col1 = col2; col2 = id;
			}
			if (push_to_merge_table(dpp[id1], id2, col1, col2)) {
				lex_error();
				ErrMsg(ER_IMPOSVAL, "attempt to merge failed");
			}
		;
    break;}
case 119:
#line 547 "parse.y"
{ boundary_file = yyvsp[0].sval; ;
    break;}
case 121:
#line 551 "parse.y"
{ push_bound(yyvsp[0].dval); ;
    break;}
case 122:
#line 552 "parse.y"
{ push_bound(yyvsp[0].dval); ;
    break;}
case 123:
#line 553 "parse.y"
{ push_bound(yyvsp[0].dval); ;
    break;}
case 125:
#line 558 "parse.y"
{ push_marginal(NULL, yyvsp[0].dval); ;
    break;}
case 126:
#line 559 "parse.y"
{ push_marginal(NULL, yyvsp[0].dval); ;
    break;}
case 127:
#line 560 "parse.y"
{ push_marginal(yyvsp[0].sval, -1.0); ;
    break;}
case 128:
#line 561 "parse.y"
{ push_marginal(yyvsp[0].sval, -1.0); ;
    break;}
}
   /* the action file gets copied in in place of this dollarsign */
#line 542 "/usr/lib/bison.simple"

  yyvsp -= yylen;
  yyssp -= yylen;
#ifdef YYLSP_NEEDED
  yylsp -= yylen;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

  *++yyvsp = yyval;

#ifdef YYLSP_NEEDED
  yylsp++;
  if (yylen == 0)
    {
      yylsp->first_line = yylloc.first_line;
      yylsp->first_column = yylloc.first_column;
      yylsp->last_line = (yylsp-1)->last_line;
      yylsp->last_column = (yylsp-1)->last_column;
      yylsp->text = 0;
    }
  else
    {
      yylsp->last_line = (yylsp+yylen-1)->last_line;
      yylsp->last_column = (yylsp+yylen-1)->last_column;
    }
#endif

  /* Now "shift" the result of the reduction.
     Determine what state that goes to,
     based on the state we popped back to
     and the rule number reduced by.  */

  yyn = yyr1[yyn];

  yystate = yypgoto[yyn - YYNTBASE] + *yyssp;
  if (yystate >= 0 && yystate <= YYLAST && yycheck[yystate] == *yyssp)
    yystate = yytable[yystate];
  else
    yystate = yydefgoto[yyn - YYNTBASE];

  goto yynewstate;

yyerrlab:   /* here on detecting error */

  if (! yyerrstatus)
    /* If not already recovering from an error, report this error.  */
    {
      ++yynerrs;

#ifdef YYERROR_VERBOSE
      yyn = yypact[yystate];

      if (yyn > YYFLAG && yyn < YYLAST)
	{
	  int size = 0;
	  char *msg;
	  int x, count;

	  count = 0;
	  /* Start X at -yyn if nec to avoid negative indexes in yycheck.  */
	  for (x = (yyn < 0 ? -yyn : 0);
	       x < (sizeof(yytname) / sizeof(char *)); x++)
	    if (yycheck[x + yyn] == x)
	      size += strlen(yytname[x]) + 15, count++;
	  msg = (char *) emalloc(size + 15);  /*KS changed malloc to emalloc*/
	  if (msg != 0)
	    {
	      strcpy(msg, "parse error");

	      if (count < 5)
		{
		  count = 0;
		  for (x = (yyn < 0 ? -yyn : 0);
		       x < (sizeof(yytname) / sizeof(char *)); x++)
		    if (yycheck[x + yyn] == x)
		      {
			strcat(msg, count == 0 ? ", expecting `" : " or `");
			strcat(msg, yytname[x]);
			strcat(msg, "'");
			count++;
		      }
		}
	      yyerror(msg);
	      efree(msg);    /*KS changed from free to efree*/
	    }
	  else
	    yyerror ("parse error; also virtual memory exceeded");
	}
      else
#endif /* YYERROR_VERBOSE */
	yyerror("parse error");
    }

  goto yyerrlab1;
yyerrlab1:   /* here on error raised explicitly by an action */

  if (yyerrstatus == 3)
    {
      /* if just tried and failed to reuse lookahead token after an error, discard it.  */

      /* return failure if at end of input */
      if (yychar == YYEOF)
	YYABORT;

#if YYDEBUG != 0
      if (yydebug)
	fprintf(stderr, "Discarding token %d (%s).\n", yychar, yytname[yychar1]);
#endif

      yychar = YYEMPTY;
    }

  /* Else will try to reuse lookahead token
     after shifting the error token.  */

  yyerrstatus = 3;		/* Each real token shifted decrements this */

  goto yyerrhandle;

yyerrdefault:  /* current state does not do anything special for the error token. */

#if 0
  /* This is wrong; only states that explicitly want error tokens
     should shift them.  */
  yyn = yydefact[yystate];  /* If its default is to accept any token, ok.  Otherwise pop it.*/
  if (yyn) goto yydefault;
#endif

yyerrpop:   /* pop the current state because it cannot handle the error token */

  if (yyssp == yyss) YYABORT;
  yyvsp--;
  yystate = *--yyssp;
#ifdef YYLSP_NEEDED
  yylsp--;
#endif

#if YYDEBUG != 0
  if (yydebug)
    {
      short *ssp1 = yyss - 1;
      fprintf (stderr, "Error: state stack now");
      while (ssp1 != yyssp)
	fprintf (stderr, " %d", *++ssp1);
      fprintf (stderr, "\n");
    }
#endif

yyerrhandle:

  yyn = yypact[yystate];
  if (yyn == YYFLAG)
    goto yyerrdefault;

  yyn += YYTERROR;
  if (yyn < 0 || yyn > YYLAST || yycheck[yyn] != YYTERROR)
    goto yyerrdefault;

  yyn = yytable[yyn];
  if (yyn < 0)
    {
      if (yyn == YYFLAG)
	goto yyerrpop;
      yyn = -yyn;
      goto yyreduce;
    }
  else if (yyn == 0)
    goto yyerrpop;

  if (yyn == YYFINAL)
    YYACCEPT;

#if YYDEBUG != 0
  if (yydebug)
    fprintf(stderr, "Shifting error token, ");
#endif

  *++yyvsp = yylval;
#ifdef YYLSP_NEEDED
  *++yylsp = yylloc;
#endif

  yystate = yyn;
  goto yynewstate;

 yyacceptlab:
  /* YYACCEPT comes here.  */
  if (yyfree_stacks)
    {
      efree (yyss);   /*KS changed from free to efree*/
      efree (yyvs);
#ifdef YYLSP_NEEDED
      efree (yyls);
#endif
    }
  return 0;

 yyabortlab:
  /* YYABORT comes here.  */
  if (yyfree_stacks)
    {
      efree (yyss);     /*KS changed from free to efree*/
      efree (yyvs);
#ifdef YYLSP_NEEDED
      efree (yyls);
#endif
    }
  return 1;
}
#line 564 "parse.y"


static void push_to_v(const char *mod, double sill, double range, double *d,
		int fit_sill, int fit_range) {
	VGM_MODEL vm;

	init_variogram_part(&vm);
	vm.model = which_variogram_model(mod);
	vm.range = range;
	vm.sill = sill;
	vm.fit_sill = fit_sill;
	vm.fit_range = fit_range;
	if (d /*!= NULL*/ && d[0] != -9999.0)
		vm.tm_range = get_tm(d);
	push_variogram_model(v, vm);
}

static int is_data_expr(DATA *d, GSTAT_EXPR *expr, const char *fld) {
#define TABLE_SIZE 27
	GSTAT_EXPR data_options[TABLE_SIZE];
	int i = 0;
#define fill_table(n, p, w, l) \
 data_options[i].name = n; data_options[i].ptr = p; \
 data_options[i].what = w; data_options[i].limit = l; i++;

/* set up table: */
	fill_table("x",          &(d->colnx),        1, 2 ) // IS_INT, GTZERO  )
	fill_table("y",          &(d->colny),        1, 2 ) // IS_INT, GTZERO  )
	fill_table("z",          &(d->colnz),        1, 2 ) // IS_INT, GTZERO  )
	fill_table("v",          &(d->colnvalue),    1, 2 ) // IS_INT, GTZERO  )
	fill_table("V",          &(d->colnvariance), 1, 2 ) // IS_INT, GTZERO  )
	fill_table("d",          &(d->polynomial_degree), 1, 2 ) // IS_INT, GEZERO  )
	fill_table("max",        &(d->sel_max),      1, 1 ) // IS_INT, GEZERO  )
	fill_table("omax",       &(d->oct_max),      1, 1 ) // IS_INT, GEZERO  )
	fill_table("min",        &(d->sel_min),      1, 1 ) // IS_INT, GEZERO  )
	fill_table("n$max",      &(d->init_max),     1, 1 ) // IS_INT, GEZERO  )
	fill_table("togrid",     &(d->togrid),       1, 1 ) // IS_INT,  GEZERO )
	fill_table("I",          &(d->Icutoff),      2, 0 ) // IS_REAL, NOLIMIT )
	fill_table("mv",         &(d->mv),           2, 0 ) // IS_REAL, NOLIMIT )
	fill_table("rad$ius",    &(d->sel_rad),      2, 2 ) // IS_REAL, GTZERO  )
	fill_table("dX",         &(d->dX),           2, 1 ) // IS_REAL, GEZERO  )
	fill_table("b$eta",      &(d->beta),         5, 0 ) // IS_D_VECTOR, NOLIMIT )
	fill_table("stan$dard",  &(d->standard),     6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("log",        &(d->log),          6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("av$erage",   &(d->average),      6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("du$mmy",     &(d->dummy),        6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("res$idual",  &(d->calc_residuals), 6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("vdist",      &(d->vdist),        6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("force",      &(d->force),        6, 0 ) // NO_ARG, NOLIMIT )
	fill_table("Cat$egory",   &(d->Category),     4, 0 ) // IS_STRING, NOLIMIT )
	fill_table("ID",         &(d->coln_id),      1, 2 ) // IS_INT, GTZERO  )
	fill_table("VarF$unction", &(d->var_fn_str),  4, 0 ) // IS_STRING, NOLIMIT  )
	fill_table(NULL, NULL, 0, 0 )

/* check TABLE_SIZE was set correctly... */
	assert(i == TABLE_SIZE);

	expr->ptr = NULL;
	expr->what = 0;//UNKNOWN;
	expr->limit = 0;//NOLIMIT;

	for (i = 0; data_options[i].name /*!= NULL*/; i++) {
		if (almost_equals(fld, data_options[i].name)) {
			expr->name = fld;
			expr->ptr = data_options[i].ptr;
			expr->what = data_options[i].what;
			expr->limit = data_options[i].limit;
			if (expr->what == 6)//NO_ARG)
				*((int *) expr->ptr) = 1;
			return 1;
		}
	}

	/* non-standard cases not in data_options[] table: */
	if (almost_equals(fld, "s$tratum")) {
		if (d->id != ID_OF_VALDATA)
			return 0;
		expr->ptr = &(d->colns);
		expr->what = 1;//IS_INT;
		expr->limit = 3;//GTZERO;
		d->what_is_u = 3;//U_ISSTRATUM;
	} else if (almost_equals(fld, "av$erage")) {
		d->average = 1; expr->what = 6;//NO_ARG;
	} else if (almost_equals(fld, "noav$erage")) {
		d->average = 0; expr->what = 6;//NO_ARG;
	} else if (almost_equals(fld, "nores$idual")) {
		d->calc_residuals = 0; expr->what = 6;//NO_ARG;
	} else if (almost_equals(fld, "square")) {
		d->square = 1; expr->what = 6;//NO_ARG;
	} else if (almost_equals(fld, "c")) {
		pr_warning("use `v' instead of `c' in data definition");
	} else if (almost_equals(fld, "sk_mean")) { /* move it to beta: */
		d->beta = NULL;
		d->beta = push_to_vector(-9999.0, d->beta);
		expr->ptr = &(d->beta->val[0]);
		expr->what = 3;//IS_REAL;
		expr->limit = 0;//NOLIMIT;
	}

	return (expr->what != 0);//UNKNOWN);
}

static int is_set_expr(GSTAT_EXPR *expr, const char *name) {
/*
 * parse sequences like `set zmap = 50.0;' or `set zmap = 50, idp = 2.5;'
 * (int, float or string)
 */
	int i;

	const GSTAT_EXPR set_options[] = {
	{ "cn$_max",        &gl_cn_max,       3, 2 }, // IS_REAL, GTZERO  },
	{ "co$incide",      &gl_coincide,     1, 1 }, // IS_INT,  GEZERO  },
	{ "Cr$essie",       &gl_cressie,      1, 1 }, // IS_INT,  GEZERO  },
	{ "a$lpha",         &gl_alpha,        3, 1 }, // IS_REAL, GEZERO  },
	{ "b$eta",          &gl_beta,         3, 1 }, // IS_REAL, GEZERO  },
	{ "c$utoff",        &gl_cutoff,       3, 2 }, // IS_REAL, GTZERO  },
	{ "de$bug",         &debug_level,     1, 1 }, // IS_INT,  GEZERO  },
	{ "display",        &gl_display,      4, 0 }, // IS_STRING, NOLIMIT },
	{ "do$ts",          &gl_dots,         1, 1 }, // IS_INT,  GEZERO  },
	{ "fit",            &gl_fit,          1, 1 }, // IS_INT,  GEZERO  },
	{ "fit_l$imit",     &gl_fit_limit,    3, 2 }, // IS_REAL, GTZERO  },
	{ "fo$rmat",        &gl_format,       4, 0 }, // IS_STRING, NOLIMIT },
	{ "fr$action",      &gl_fraction,     3, 2 }, // IS_REAL, GTZERO  },
	{ "gcv",            &gl_gcv,          3, 2 }, // IS_REAL, GTZERO  },
	{ "gls$_residuals", &gl_gls_residuals, 1, 1 }, // IS_INT, GEZERO  },
	{ "gnuplot",        &gl_gnuplot,      4, 0 }, // IS_STRING, NOLIMIT },
	{ "gnuplot35",      &gl_gnuplot35,    4, 0 }, // IS_STRING, NOLIMIT },
	{ "gpt$erm",        &gl_gpterm,       4, 0 }, // IS_STRING, NOLIMIT  },
	{ "id$p",           &gl_idp,          3, 2 }, // IS_REAL, GTZERO  },
	{ "in$tervals",     &gl_n_intervals,  1, 2 }, // IS_INT,  GTZERO  },
	{ "it$er",          &gl_iter,         1, 1 }, // IS_INT,  GEZERO  },
	{ "j$graph",        &gl_jgraph,       1, 1 }, // IS_INT,  GEZERO  },
	{ "lhs",            &gl_lhs,          1, 1 }, // IS_INT,  GEZERO  },
	{ "log$file",       &logfile_name,    4, 0 }, // IS_STRING, NOLIMIT },
	{ "mv$string",		&gl_mv_string,    4, 0 }, // IS_STRING, NOLIMIT },
	{ "n_uk",           &gl_n_uk,         1, 1 }, // IS_INT,  GEZERO  },
	{ "numbers",        &gl_numbers,      1, 1 }, // IS_INT,  GEZERO  },
	{ "nb$lockdiscr",   &gl_nblockdiscr,  1, 2 }, // IS_INT,  GTZERO  },
	{ "no$check",       &gl_nocheck,      1, 1 }, // IS_INT,  GEZERO  },
	{ "ns$im",          &gl_nsim,         1, 2 }, // IS_INT,  GTZERO  },
	{ "o$utputfile",    &o_filename,      4, 0 }, // IS_STRING, NOLIMIT },
	{ "or$der",         &gl_order,        1, 1 }, // IS_INT,  GEZERO },
	{ "pag$er",         &gl_pager,        4, 0 }, // IS_STRING, NOLIMIT },
	{ "pl$otfile",      &gl_gnufile,      4, 0 }, // IS_STRING, NOLIMIT },
	{ "q$uantile",      &gl_quantile,     3, 2 }, // IS_REAL, GTZERO  },
	{ "rp",             &gl_rp,           1, 1 }, // IS_INT,  GEZERO  },
	{ "sec$ure",        &gl_secure,       1, 2 }, // IS_INT,  GTZERO  },
	{ "see$d",          &gl_seed,         1, 2 }, // IS_INT,  GTZERO  },
	{ "useed",          &gl_seed,         2, 1 }, // IS_UINT,  GEZERO  },
	{ "spa$rse",        &gl_sparse,       1, 1 }, // IS_INT,  GEZERO  },
	{ "spi$ral",        &gl_spiral,       1, 1 }, // IS_INT,  GEZERO  },
	{ "spl$it",         &gl_split,        1, 2 }, // IS_INT,  GTZERO  },
	{ "sy$mmetric",     &gl_sym_ev,       1, 1 }, // IS_INT,  GEZERO  },
	{ "tol_h$or",       &gl_tol_hor,      3, 1 }, // IS_REAL, GEZERO  },
	{ "tol_v$er",       &gl_tol_ver,      3, 1 }, // IS_REAL, GEZERO  },
	{ "v$erbose",       &debug_level,     1, 1 }, // IS_INT,  GEZERO  },
	{ "w$idth",         &gl_iwidth,       3, 1 }, // IS_REAL, GEZERO  },
	{ "x$valid",        &gl_xvalid,       1, 1 }, // IS_INT,  GEZERO  },
	{ "zero_di$st",     &gl_zero_est,     1, 1 }, // IS_INT,  GEZERO  },
	{ "zero",           &gl_zero,         3, 1 }, // IS_REAL, GEZERO  },
	{ "zm$ap",          &gl_zmap,         3, 0 }, // IS_REAL, NOLIMIT },
	{ NULL, NULL, 0, 0 }
	};

	for (i = 0; set_options[i].name; i++)
		if (almost_equals(name, set_options[i].name))
			break; /* break out i-loop */
	if (!(set_options[i].name) /*== NULL*/)
		return 0;

	if (almost_equals((const char *)name,"nb$lockdiscr"))
		gl_gauss = 0; /* side effect */

	expr->name = name;
	expr->ptr = set_options[i].ptr;
	expr->what = set_options[i].what;
	expr->limit = set_options[i].limit;

	return 1;
}

static void check_assign_expr(GSTAT_EXPR *expr) {
/* for INT and REAL expressions, check range */
	double val;

	switch(expr->what) {
		case 1/*IS_INT*/:
			val = (double) (*((int *)(expr->ptr)));
			break;
		case 3/*IS_REAL*/:
			val = (*((double *)(expr->ptr)));
			break;
		default:
			return;
	}
	if (expr->limit == 1/*GEZERO*/ && val < 0.0) {
		lex_error();
		pr_warning("value should be non-negative");
		ErrMsg(ER_IMPOSVAL, expr->name);
	}
	if (expr->limit == 2/*GTZERO*/ && val <= 0.0) {
		lex_error();
		pr_warning("value should be positive");
		ErrMsg(ER_IMPOSVAL, expr->name);
	}
}

static void push_data_X(DATA *d, int id) {
	if (id == -1) { /* remove default intercept */
		if (d->n_X > 1) {
			lex_error();
			ErrMsg(ER_SYNTAX, "-1 only as first argument following X=");
		}
		d->n_X = 0;
	} else if (id == 0) {
		lex_error();
		ErrMsg(ER_SYNTAX, "intercept is default");
	} else /* id > 0 */
		data_add_X(d, id);
}

static int is_block_expr(GSTAT_EXPR *expr, const char *s) {
	DPOINT *bp;

	bp = get_block_p();
	expr->name = s;
	expr->limit = 1/*GEZERO*/;
	expr->what = 3/*IS_REAL*/;
	if (almost_equals(s, "dx"))
		expr->ptr = &(bp->x);
	else if (almost_equals(s, "dy"))
		expr->ptr = &(bp->y);
	else if (almost_equals(s, "dz"))
		expr->ptr = &(bp->z);
	else
		return 0;
	return 1;
}

static ANIS_TM *get_tm(double anis[5]) {
/* Part of this routine was taken from GSLIB, first edition:
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
C                                                                      %
C Copyright (C) 1992 Stanford Center for Reservoir Forecasting.  All   %
C rights reserved.  Distributed with: C.V. Deutsch and A.G. Journel.   %
C ``GSLIB: Geostatistical Software Library and User's Guide,'' Oxford  %
C University Press, New York, 1992.                                    %
C                                                                      %
C The programs in GSLIB are distributed in the hope that they will be  %
C useful, but WITHOUT ANY WARRANTY.  No author or distributor accepts  %
C responsibility to anyone for the consequences of using them or for   %
C whether they serve any particular purpose or work at all, unless he  %
C says so in writing.  Everyone is granted permission to copy, modify  %
C and redistribute the programs in GSLIB, but only under the condition %
C that this notice and the above copyright notice remain intact.       %
C                                                                      %
C%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%%
*/
	int i;
	double alpha, beta, theta, sina, sinb, sint, cosa, cosb, cost, afac1, afac2;
	ANIS_TM *t = NULL;

/* 
	About naming convention:

	gstat     GSLIB
	===============
	anis[0]    ang1 (first anis. par. for 2D)
	anis[1]    ang2
	anis[2]    ang3
	anis[3]   anis1 (second anis. par. for 2D)
	anis[4]   anis2
*/

#define ANIS_ERR(x) message("parsing anis. pars. %g,%g,%g,%g,%g -- error on %g\n", \
	anis[0],anis[1],anis[2],anis[3],anis[4],x)
#define DEG2RAD (PI/180.0)

	for (i = 0; i < 3; i++) {
		if (anis[i] < 0 || anis[i] >= 360) {
			ANIS_ERR(anis[i]);
			ErrMsg(ER_RANGE, "this value should be in [0..360>");
		}
	}
	for (i = 3; i < 5; i++) {
		if (anis[i] <= 0.0 || anis[i] > 1.0) {
			ANIS_ERR(anis[i]);
			ErrMsg(ER_RANGE, "this value should be in <0..1]");
		}
	}

	/* from GSLIB: */
	if (anis[0] >= 0.0 && anis[0] < 270)
		alpha = (double) (90.0 - anis[0]) * DEG2RAD;
	else
		alpha = (double) (450.0 - anis[0]) * DEG2RAD;
	beta = -1.0 * (double) anis[1] * DEG2RAD;
	theta =       (double) anis[2] * DEG2RAD;

	sina = sin(alpha);
	sinb = sin(beta);
	sint = sin(theta);
	cosa = cos(alpha);
	cosb = cos(beta);
	cost = cos(theta);

	afac1 = 1.0 / MAX((double) anis[3], (double) EPSILON);
	afac2 = 1.0 / MAX((double) anis[4], (double) EPSILON);

	t = (ANIS_TM *) emalloc(sizeof(ANIS_TM));

	t->angle[0] = anis[0];
	t->angle[1] = anis[1];
	t->angle[2] = anis[2];
	t->ratio[0] = anis[3];
	t->ratio[1] = anis[4];
	t->tm[0][0] =       (cosb * cosa);
	t->tm[0][1] =       (cosb * sina);
	t->tm[0][2] =       (-sinb);
	t->tm[1][0] = afac1*(-cost*sina + sint*sinb*cosa);
	t->tm[1][1] = afac1*(cost*cosa + sint*sinb*sina);
	t->tm[1][2] = afac1*( sint * cosb);
	t->tm[2][0] = afac2*(sint*sina + cost*sinb*cosa);
	t->tm[2][1] = afac2*(-sint*cosa + cost*sinb*sina);
	t->tm[2][2] = afac2*(cost * cosb);
	return t;
}

static void push_marginal(char *name, double value) {
	static int names = -1;

	if ((names == -1) && (name))
		names = *(name /*!= NULL*/);

	if (name) {
		if (!names) {
			lex_error();
			ErrMsg(ER_SYNTAX, "only real values allowed"); 
		}
		gl_marginal_names = (char **) erealloc(gl_marginal_names,
			++gl_n_marginals * sizeof(char *));
		gl_marginal_names[gl_n_marginals - 1] = name;
	} else {
		if (names) {
			lex_error();
			ErrMsg(ER_SYNTAX, "only quoted strings allowed"); 
		}
		gl_marginal_values = (double *) erealloc (gl_marginal_values,
			++gl_n_marginals * sizeof(double));
		gl_marginal_values[gl_n_marginals - 1] = value;
	}
	return;
}

static void reset_parser(void) {
/* savety first: reset all static globals (should be unnessesary) */
	v = NULL;
	d = NULL;
	bp = NULL;
	ofn = NULL;
	expr.ptr = NULL;
	expr.what =  0;//UNKNOWN;
	expr.limit =  0;//NOLIMIT;
	id = id1 = id2 = col1 = col2 = -1;
}

int parse_cmdo(const char *cmd, const char *fname) {  /*KS added o so as not to conflict with older version*/
	set_lex_source(const_cast <char *>(cmd), fname);
	reset_parser();
	return yyparse();
}

int parse_file(const char *fname) {
/*
 * parse commands in file fname
 */
	int stdin_isatty = 1;
	char *cp;

	if (!fname /*== NULL*/ || strcmp(fname, "-") == 0) {
#ifdef HAVE_UNISTD_H
		stdin_isatty = isatty(fileno(stdin));
#endif
		if (stdin_isatty)
			cp = string_prompt("gstat> ");
		else
			cp = string_file(NULL);
	} else /* read from file */
		cp = string_file(fname);

	if (parse_cmdo(cp, fname))
		ErrMsg(ER_SYNTAX, fname);
	efree(cp);

	if (boundary_file /*!= NULL*/) {
		cp = string_file(boundary_file);
		if (parse_cmdo(cp, boundary_file))
			ErrMsg(ER_SYNTAX, boundary_file);
		efree(cp);
	}

	if (vector_only && !allow_vector_only)
		ErrMsg(ER_SYNTAX, fname);

	return 0;
}

/*void parse_gstatrc(void) {
	char *fname = NULL, *cp;

	if ((fname = getenv(GSTATRC)) != NULL) {
		if (! file_exists(fname)) {
			message("environment variable %s:\n", GSTATRC);
			ErrMsg(ER_READ, fname);
		}
		parse_file(fname);
	} else if ((cp = getenv("HOME")) != NULL) {
		fname = (char *) emalloc(strlen(cp) + strlen(HOMERCFILE) + 2);
		sprintf(fname, "%s/%s", cp, HOMERCFILE);
		if (file_exists(fname))
			parse_file(fname);
		efree(fname);
	}
	return;
} */

int read_variogramo(VARIOGRAM *v, const char *source) {     /*KS added o to name so as not to conflict with parsecmd version*/
	char *cp;
	int rval;

	parse_variogram = v;
	cp = (char *) emalloc((strlen(source) + 20) * sizeof(char));
	sprintf(cp, "variogram(): %s;", source);
	rval = parse_cmdo(cp, NULL);
	parse_variogram = NULL; /* for savety */
	efree(cp);
	return rval;
}

int read_vector(D_VECTOR *d, char *fname) {
	int rval;

	assert(d /*!= NULL*/);
	sd_vector = d;

	allow_vector_only = 1;

	rval = parse_file(fname);

	if (! vector_only)  {
		message("stat: only numeric input allowed -- \n");
		ErrMsg(ER_IMPOSVAL, fname);
	}

	return rval;
}

static void verify_data(DATA *d) { /* declaration : contents */

	if (d->var_fn_str /*!= NULL*/) {
		if (almost_equals(d->var_fn_str, "mu")) {
			d->variance_fn = v_mu;
		} else if (almost_equals(d->var_fn_str, "mu(1-mu)")) {
			d->variance_fn = v_bin;
		} else {
			lex_error();
			message("variance function not supported:\n");
			ErrMsg(ER_SYNTAX, d->var_fn_str);
		}
	}
}
