enum GLS_WHAT {
	GLS_BLUE /* generalized least squares best linear unbiased estimate */,
	GLS_BLUP /* gls best linear unbiased predictor */,
	GLS_BLP  /* gls best linear predictor */,
	UPDATE /* update estimate: use previously calculated weights */
};

#define GLS_ESTIMATE 0
#define GLS_PREDICT  1 
#define GLS_UPDATE   2 

#define DO_PREDICT(mode) (mode & GLS_PREDICT_BIT)
#define DO_UPDATE(mode)  (mode & GLS_UPDATE_BIT)

void gls(DATA **d, int n_vars, enum GLS_WHAT pred, DPOINT *where, double *est);
double *make_gls(DATA *d, int calc_residuals);
void free_glm(void *v_glm);
