/***************************************************************************/
/*                                                                         */
/*  PURPOSE:  To define environment and compiler specific things           */
/***************************************************************************/

#if defined(MSDOS)   /* predefined in MicroSoft C 6.0 */ \
 || defined(__MSDOS__) /* predefined in Turbo C 2.0 */ 
#	define DOS
#endif

#ifdef THINK_C       /* predefined in Think C 4.0 */
#	define MAC
#endif

/* define UNIX with cc -c DUNIX .... etc   */
#ifndef DOS
#	ifndef MAC
#		ifndef INTEL32
# 			define UNIX
#		endif
#	endif
#endif

/***************************************************************************/
/*                                                                         */
/*  DOS: two memory models are supported                                   */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/*                                                                         */
/*  MAC                                                                    */
/*                                                                         */
/***************************************************************************/


/***************************************************************************/
/*                                                                         */
/*  UNIX 4.2 Berkeley                                                     */
/*                                                                         */
/***************************************************************************/

/***************************************************************************/
/*                                                                         */
/*  Types and constants who are equal for all environments                 */
/*                                                                         */
/***************************************************************************/


/***************************************************************************/
/*                                                                         */
/*  C-library redefinitions                                                */
/*                                                                         */
/***************************************************************************/

/* THINK C only supports malloc for */
/* blocks < 64 Kb                   */

#ifdef MAC

void	*MacMalloc(long size);
void  	MacFree(void *ptr);
#define MALLOC(size)  MacMalloc((long)size)   
#define FREE(ptr)     MacFree((void *)ptr)
/* Both functions are declared macfixes.c */

#else

#define MALLOC(size)  malloc(size)
#define FREE(ptr)     free(ptr)

#endif /* MAC */

/*****************************/
/*   ptr to void             */
/*****************************/

#define VOID void

