
#ifndef __STDIO
#include <stdio.h>
#define __STDIO
#endif


#ifdef DEBUG

#include <assert.h>

#define my_assert(exp)	assert(exp)

extern FILE *fDump; /* declared in initpars.c */

void CheckHeap(void);
#define HEAPCHECK      {printf("%s %u ",__FILE__,__LINE__);CheckHeap();}

#define DEBUGCOND(cond)		my_assert(cond)
#define IFDEBUG(action)     	action
#define IS_TEMPORARY(action)	{printf("temporary solution\n");action;}

#define POSTCOND(cond)		my_assert(cond)
#define PRECOND(cond)		my_assert(cond)

#else /* DEBUG not defined */

#define IS_TEMPORARY(action)	{printf("ERROR temporary solution still active\n");action;}
#define HEAPCHECK      {printf("Error heap Check still active %s %u ",__FILE__,__LINE__);exit(1);}

#define DEBUGCOND(cond)
#define IFDEBUG(action)

#define POSTCOND(cond)
#define PRECOND(cond)

#define CVBP

#endif /* DEBUG */
