/*
 * rrowcol.c
$Log: rrowcol.c,v $
Revision 2.0  1996/05/23 13:16:26  cees
csf2clean

Revision 1.1  1996/05/23 13:11:49  cees
Initial revision

Revision 1.5  1995/11/01 17:23:03  cees
.

 * Revision 1.4  1995/03/21  13:22:56  cees
 * *** empty log message ***
 *
 * Revision 1.3  1994/09/08  17:16:23  cees
 * added c2man docs + small code changes
 *
 * Revision 1.2  1994/09/07  16:20:25  cees
 * added angle rotation
 * added c2man doc
 *
 * Revision 1.1  1994/08/26  13:33:23  cees
 * Initial revision
 *
 */
#ifndef lint
 static const char *rcs_id = 
 "$Header: /users/pcrtree/src/libs/csf/RCS/rrowcol.c,v 2.0 1996/05/23 13:16:26 cees Exp $";
#endif

#include "csf.h"
#include "csfimpl.h"

#include <math.h> /* floor */

/* compute (fractional) row, column index from true world co-ordinate from 
 * Rcoord2RowCol computes row, column index from true world co-ordinate. 
 * The row and column co-ordinate are returned as fractions (See parameters
 * section).
 * The x,y co-ordinate
 * don't have to be on the map. They are just relative to upper left position.
 * returns:
 * .br
 *  0  if the co-ordinate is outside the map
 * .br
 *  1 if inside
 * .br
 * -1 in case of an error
 *
 * Merrno
 * ILL_CELLSIZE
 */
int Rcoords2RowCol(
 const MAP *m,  /* map handle */
 double x,      /* x of true co-ordinate */
 double y,      /* y of true co-ordinate */
 double *row,   /* write-only. Row index (y-pos). floor(row) is row number
                 * .br
                 * fmod(row, 1) is in-pixel displacement from pixel-top if row >= 0
                 * .br
                 * fmod(row, 1) is in-pixel displacement from pixel-bottom if row < 0
                 */
 double *col)   /* write-only. Column index (x-pos). floor(col) is column number
                 * .br
                 * fmod(col, 1) is in-pixel displacement from pixel-left if col >= 0
                 * .br
                 * fmod(col, 1) is in-pixel displacement from pixel-right if col < 0
                 */
{
	double row_,col_; /* use copies, func( , , ,&dummy, &dummy) will fail
	                   * otherwise
	                   */
	double cs = m->raster.cellSizeX;
	double xCol = (x - m->raster.xUL) / cs; 
	double yRow = (((m->main.projection == PT_YINCT2B) 
	                ? (y - m->raster.yUL)
	                : (m->raster.yUL - y)) / cs); 
	/* rotate clockwise: */
	double c = m->angleCos;    /* cos(t) == cos(-t) */
	double s = -(m->angleSin); /* -sin(t) == sin(-t) */
	col_  = xCol * c - yRow * s;
	row_  = xCol * s + yRow * c;

	if (m->raster.cellSizeX <= 0 || m->raster.cellSizeY <= 0
	    || (m->raster.cellSizeX != m->raster.cellSizeY ) )
	{ /* CW we should put this in Mopen */ 
		M_ERROR(ILL_CELLSIZE);
		goto error;
	}
        *row = row_;
        *col = col_;
	return( row_ >= 0 && col_ >= 0 && 
	        (m->raster.nrRows > row_) && (m->raster.nrCols > col_) );
error:  return(-1);
}


/* compute row, column number of true world co-ordinate
 * RgetRowCol computes row, column number of true world co-ordinate.
 * returns:
 * .br
 *  0  if the co-ordinate is outside the map
 * .br
 *  1 if inside
 * .br
 * -1 in case of an error
 *
 * Merrno
 * ILL_CELLSIZE
 */
int RgetRowCol(
	const MAP *m, /* map handle */
	double x,     /* x of true co-ordinate */
	double y,     /* y of true co-ordinate */
	size_t *row,   /* write-only. Row number (y-pos).
	               * Undefined if (x,y) is outside of map
	               */
	size_t *col)   /* write-only. Column number (x-pos).
	               * Undefined if (x,y) is outside of map
	               */
{
	double row_d,col_d;
	int    result;
	result = Rcoords2RowCol(m,x,y,&row_d,&col_d);
	if (result > 0)
	{
		*row = (size_t)floor(row_d);
		*col = (size_t)floor(col_d);
	}
	return(result);
}
