/*
 * rcomp.c
$Log: rcomp.c,v $
Revision 2.0  1996/05/23 13:16:26  cees
csf2clean

Revision 1.1  1996/05/23 13:11:49  cees
Initial revision

Revision 1.4  1995/11/01 17:23:03  cees
.

 * Revision 1.3  1994/09/12  12:22:37  cees
 * changed docs
 *
 * Revision 1.2  1994/09/08  17:16:23  cees
 * added c2man docs + small code changes
 *
 * Revision 1.1  1994/08/26  13:33:23  cees
 * Initial revision
 *
 */
#ifndef lint
 static const char *rcs_id = 
 "$Header: /users/pcrtree/src/libs/csf/RCS/rcomp.c,v 2.0 1996/05/23 13:16:26 cees Exp $";
#endif


/*****************************************************************/
/*    FUNCTION :  RCOMPARE                                       */
/*****************************************************************/
/*             				                         */
/*****************************************************************/


#include "csf.h"
#include "csfimpl.h"

/* compare 2 maps for their location attributes
 * Rcompare compares 2 maps for all location attributes:
 * .br
 * projection,
 * .br
 * xUL, yUL, angle,
 * .br
 * cell size and
 * .br
 * number of rows and columns
 * returns 0 if one of these attributes differ or in case of an error, 1 
 * if they are all equal.
 *
 * Merrno
 * NOT_RASTER
 */
int Rcompare(
	const MAP *m1, /* map handle 1 */
	const MAP *m2) /* map handle 2 */
{
	CHECKHANDLE_GOTO(m1, error);

	/* check if dataType is T_RASTER */
	if ((m1->main.dataType != T_RASTER)
	|| (m2->main.dataType != T_RASTER))
	{
		M_ERROR(NOT_RASTER);
		goto error;
	}

	if (
	    MgetProjection(m1) == MgetProjection(m2) && 
	    m1->raster.xUL == m2->raster.xUL &&
    	    m1->raster.yUL == m2->raster.yUL &&
	    m1->raster.cellSizeX == m2->raster.cellSizeX &&
	    m1->raster.cellSizeY == m2->raster.cellSizeY &&
	    m1->raster.angle == m2->raster.angle &&
	    m1->raster.nrRows == m2->raster.nrRows &&
	    m1->raster.nrCols == m2->raster.nrCols 
	)
		return(1);
error: 
		return(0);
}
